/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.DocumentDescription;

@SdkInternalApi
public class DocumentDescriptionMarshaller {
    private static final MarshallingInfo<String> SHA1_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Sha1").build();
    private static final MarshallingInfo<String> HASH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Hash").build();
    private static final MarshallingInfo<String> HASHTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HashType").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> OWNER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Owner").build();
    private static final MarshallingInfo<Instant> CREATEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedDate").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<List> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").build();
    private static final MarshallingInfo<List> PLATFORMTYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlatformTypes").build();
    private static final MarshallingInfo<String> DOCUMENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentType").build();
    private static final MarshallingInfo<String> SCHEMAVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaVersion").build();
    private static final MarshallingInfo<String> LATESTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestVersion").build();
    private static final MarshallingInfo<String> DEFAULTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultVersion").build();
    private static final DocumentDescriptionMarshaller INSTANCE = new DocumentDescriptionMarshaller();

    public static DocumentDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DocumentDescription documentDescription, ProtocolMarshaller protocolMarshaller) {
        if (documentDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)documentDescription.sha1(), SHA1_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.hash(), HASH_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.hashType(), HASHTYPE_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.owner(), OWNER_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.createdDate(), CREATEDDATE_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.documentVersion(), DOCUMENTVERSION_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(documentDescription.parameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall(documentDescription.platformTypes(), PLATFORMTYPES_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.documentType(), DOCUMENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.schemaVersion(), SCHEMAVERSION_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.latestVersion(), LATESTVERSION_BINDING);
            protocolMarshaller.marshall((Object)documentDescription.defaultVersion(), DEFAULTVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

