/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ssm.model.CommandPlugin;

public class CommandPluginUnmarshaller
implements Unmarshaller<CommandPlugin, JsonUnmarshallerContext> {
    private static final CommandPluginUnmarshaller INSTANCE = new CommandPluginUnmarshaller();

    public CommandPlugin unmarshall(JsonUnmarshallerContext context) throws Exception {
        CommandPlugin.Builder commandPluginBuilder = CommandPlugin.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    commandPluginBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    commandPluginBuilder.status((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("StatusDetails", targetDepth)) {
                    context.nextToken();
                    commandPluginBuilder.statusDetails((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ResponseCode", targetDepth)) {
                    context.nextToken();
                    commandPluginBuilder.responseCode((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("ResponseStartDateTime", targetDepth)) {
                    context.nextToken();
                    commandPluginBuilder.responseStartDateTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("ResponseFinishDateTime", targetDepth)) {
                    context.nextToken();
                    commandPluginBuilder.responseFinishDateTime((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("Output", targetDepth)) {
                    context.nextToken();
                    commandPluginBuilder.output((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("StandardOutputUrl", targetDepth)) {
                    context.nextToken();
                    commandPluginBuilder.standardOutputUrl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("StandardErrorUrl", targetDepth)) {
                    context.nextToken();
                    commandPluginBuilder.standardErrorUrl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("OutputS3Region", targetDepth)) {
                    context.nextToken();
                    commandPluginBuilder.outputS3Region((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("OutputS3BucketName", targetDepth)) {
                    context.nextToken();
                    commandPluginBuilder.outputS3BucketName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("OutputS3KeyPrefix", targetDepth)) {
                    context.nextToken();
                    commandPluginBuilder.outputS3KeyPrefix((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (CommandPlugin)commandPluginBuilder.build();
    }

    public static CommandPluginUnmarshaller getInstance() {
        return INSTANCE;
    }
}

