/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionMetadata;

@SdkInternalApi
public class AutomationExecutionMetadataMarshaller {
    private static final MarshallingInfo<String> AUTOMATIONEXECUTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutomationExecutionId").build();
    private static final MarshallingInfo<String> DOCUMENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentName").build();
    private static final MarshallingInfo<String> DOCUMENTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DocumentVersion").build();
    private static final MarshallingInfo<String> AUTOMATIONEXECUTIONSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AutomationExecutionStatus").build();
    private static final MarshallingInfo<Instant> EXECUTIONSTARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionStartTime").build();
    private static final MarshallingInfo<Instant> EXECUTIONENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionEndTime").build();
    private static final MarshallingInfo<String> EXECUTEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutedBy").build();
    private static final MarshallingInfo<String> LOGFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogFile").build();
    private static final MarshallingInfo<Map> OUTPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Outputs").build();
    private static final AutomationExecutionMetadataMarshaller INSTANCE = new AutomationExecutionMetadataMarshaller();

    public static AutomationExecutionMetadataMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AutomationExecutionMetadata automationExecutionMetadata, ProtocolMarshaller protocolMarshaller) {
        if (automationExecutionMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)automationExecutionMetadata.automationExecutionId(), AUTOMATIONEXECUTIONID_BINDING);
            protocolMarshaller.marshall((Object)automationExecutionMetadata.documentName(), DOCUMENTNAME_BINDING);
            protocolMarshaller.marshall((Object)automationExecutionMetadata.documentVersion(), DOCUMENTVERSION_BINDING);
            protocolMarshaller.marshall((Object)automationExecutionMetadata.automationExecutionStatus(), AUTOMATIONEXECUTIONSTATUS_BINDING);
            protocolMarshaller.marshall((Object)automationExecutionMetadata.executionStartTime(), EXECUTIONSTARTTIME_BINDING);
            protocolMarshaller.marshall((Object)automationExecutionMetadata.executionEndTime(), EXECUTIONENDTIME_BINDING);
            protocolMarshaller.marshall((Object)automationExecutionMetadata.executedBy(), EXECUTEDBY_BINDING);
            protocolMarshaller.marshall((Object)automationExecutionMetadata.logFile(), LOGFILE_BINDING);
            protocolMarshaller.marshall(automationExecutionMetadata.outputs(), OUTPUTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

