/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.InventoryResultEntity;
import software.amazon.awssdk.services.ssm.model.InventoryResultEntityListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetInventoryResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetInventoryResponse> {
    private final List<InventoryResultEntity> entities;
    private final String nextToken;

    private GetInventoryResponse(BuilderImpl builder) {
        this.entities = builder.entities;
        this.nextToken = builder.nextToken;
    }

    public List<InventoryResultEntity> entities() {
        return this.entities;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.entities() == null ? 0 : this.entities().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInventoryResponse)) {
            return false;
        }
        GetInventoryResponse other = (GetInventoryResponse)((Object)obj);
        if (other.entities() == null ^ this.entities() == null) {
            return false;
        }
        if (other.entities() != null && !other.entities().equals(this.entities())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.entities() != null) {
            sb.append("Entities: ").append(this.entities()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<InventoryResultEntity> entities;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInventoryResponse model) {
            this.setEntities(model.entities);
            this.setNextToken(model.nextToken);
        }

        public final Collection<InventoryResultEntity> getEntities() {
            return this.entities;
        }

        @Override
        public final Builder entities(Collection<InventoryResultEntity> entities) {
            this.entities = InventoryResultEntityListCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(InventoryResultEntity ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        public final void setEntities(Collection<InventoryResultEntity> entities) {
            this.entities = InventoryResultEntityListCopier.copy(entities);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public GetInventoryResponse build() {
            return new GetInventoryResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetInventoryResponse> {
        public Builder entities(Collection<InventoryResultEntity> var1);

        public Builder entities(InventoryResultEntity ... var1);

        public Builder nextToken(String var1);
    }
}

