/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.transform.DocumentVersionInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DocumentVersionInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, DocumentVersionInfo> {
    private final String name;
    private final String documentVersion;
    private final Instant createdDate;
    private final Boolean isDefaultVersion;

    private DocumentVersionInfo(BuilderImpl builder) {
        this.name = builder.name;
        this.documentVersion = builder.documentVersion;
        this.createdDate = builder.createdDate;
        this.isDefaultVersion = builder.isDefaultVersion;
    }

    public String name() {
        return this.name;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public Instant createdDate() {
        return this.createdDate;
    }

    public Boolean isDefaultVersion() {
        return this.isDefaultVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.documentVersion() == null ? 0 : this.documentVersion().hashCode());
        hashCode = 31 * hashCode + (this.createdDate() == null ? 0 : this.createdDate().hashCode());
        hashCode = 31 * hashCode + (this.isDefaultVersion() == null ? 0 : this.isDefaultVersion().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentVersionInfo)) {
            return false;
        }
        DocumentVersionInfo other = (DocumentVersionInfo)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.documentVersion() == null ^ this.documentVersion() == null) {
            return false;
        }
        if (other.documentVersion() != null && !other.documentVersion().equals(this.documentVersion())) {
            return false;
        }
        if (other.createdDate() == null ^ this.createdDate() == null) {
            return false;
        }
        if (other.createdDate() != null && !other.createdDate().equals(this.createdDate())) {
            return false;
        }
        if (other.isDefaultVersion() == null ^ this.isDefaultVersion() == null) {
            return false;
        }
        return other.isDefaultVersion() == null || other.isDefaultVersion().equals(this.isDefaultVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.documentVersion() != null) {
            sb.append("DocumentVersion: ").append(this.documentVersion()).append(",");
        }
        if (this.createdDate() != null) {
            sb.append("CreatedDate: ").append(this.createdDate()).append(",");
        }
        if (this.isDefaultVersion() != null) {
            sb.append("IsDefaultVersion: ").append(this.isDefaultVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DocumentVersionInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String documentVersion;
        private Instant createdDate;
        private Boolean isDefaultVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentVersionInfo model) {
            this.setName(model.name);
            this.setDocumentVersion(model.documentVersion);
            this.setCreatedDate(model.createdDate);
            this.setIsDefaultVersion(model.isDefaultVersion);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Boolean getIsDefaultVersion() {
            return this.isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        public DocumentVersionInfo build() {
            return new DocumentVersionInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DocumentVersionInfo> {
        public Builder name(String var1);

        public Builder documentVersion(String var1);

        public Builder createdDate(Instant var1);

        public Builder isDefaultVersion(Boolean var1);
    }
}

