/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ssm.model.InstanceInformation;
import software.amazon.awssdk.services.ssm.model.InstanceInformationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstanceInformationResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeInstanceInformationResponse> {
    private final List<InstanceInformation> instanceInformationList;
    private final String nextToken;

    private DescribeInstanceInformationResponse(BuilderImpl builder) {
        this.instanceInformationList = builder.instanceInformationList;
        this.nextToken = builder.nextToken;
    }

    public List<InstanceInformation> instanceInformationList() {
        return this.instanceInformationList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceInformationList() == null ? 0 : this.instanceInformationList().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceInformationResponse)) {
            return false;
        }
        DescribeInstanceInformationResponse other = (DescribeInstanceInformationResponse)((Object)obj);
        if (other.instanceInformationList() == null ^ this.instanceInformationList() == null) {
            return false;
        }
        if (other.instanceInformationList() != null && !other.instanceInformationList().equals(this.instanceInformationList())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceInformationList() != null) {
            sb.append("InstanceInformationList: ").append(this.instanceInformationList()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<InstanceInformation> instanceInformationList;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceInformationResponse model) {
            this.setInstanceInformationList(model.instanceInformationList);
            this.setNextToken(model.nextToken);
        }

        public final Collection<InstanceInformation> getInstanceInformationList() {
            return this.instanceInformationList;
        }

        @Override
        public final Builder instanceInformationList(Collection<InstanceInformation> instanceInformationList) {
            this.instanceInformationList = InstanceInformationListCopier.copy(instanceInformationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInformationList(InstanceInformation ... instanceInformationList) {
            this.instanceInformationList(Arrays.asList(instanceInformationList));
            return this;
        }

        public final void setInstanceInformationList(Collection<InstanceInformation> instanceInformationList) {
            this.instanceInformationList = InstanceInformationListCopier.copy(instanceInformationList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeInstanceInformationResponse build() {
            return new DescribeInstanceInformationResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInstanceInformationResponse> {
        public Builder instanceInformationList(Collection<InstanceInformation> var1);

        public Builder instanceInformationList(InstanceInformation ... var1);

        public Builder nextToken(String var1);
    }
}

