/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.ModifyDocumentPermissionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ModifyDocumentPermissionRequestModelMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> PERMISSIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PermissionType").isBinary(false).build();
    private static final MarshallingInfo<List> ACCOUNTIDSTOADD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountIdsToAdd").isBinary(false).build();
    private static final MarshallingInfo<List> ACCOUNTIDSTOREMOVE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountIdsToRemove").isBinary(false).build();
    private static final ModifyDocumentPermissionRequestModelMarshaller INSTANCE = new ModifyDocumentPermissionRequestModelMarshaller();

    private ModifyDocumentPermissionRequestModelMarshaller() {
    }

    public static ModifyDocumentPermissionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ModifyDocumentPermissionRequest modifyDocumentPermissionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)modifyDocumentPermissionRequest), (String)"modifyDocumentPermissionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)modifyDocumentPermissionRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)modifyDocumentPermissionRequest.permissionTypeAsString(), PERMISSIONTYPE_BINDING);
            protocolMarshaller.marshall(modifyDocumentPermissionRequest.accountIdsToAdd(), ACCOUNTIDSTOADD_BINDING);
            protocolMarshaller.marshall(modifyDocumentPermissionRequest.accountIdsToRemove(), ACCOUNTIDSTOREMOVE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

