/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTarget;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MaintenanceWindowTargetMarshaller {
    private static final MarshallingInfo<String> WINDOWID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowId").isBinary(false).build();
    private static final MarshallingInfo<String> WINDOWTARGETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WindowTargetId").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").isBinary(false).build();
    private static final MarshallingInfo<List> TARGETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Targets").isBinary(false).build();
    private static final MarshallingInfo<String> OWNERINFORMATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerInformation").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MaintenanceWindowTargetMarshaller INSTANCE = new MaintenanceWindowTargetMarshaller();

    private MaintenanceWindowTargetMarshaller() {
    }

    public static MaintenanceWindowTargetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MaintenanceWindowTarget maintenanceWindowTarget, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)maintenanceWindowTarget, (String)"maintenanceWindowTarget");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)maintenanceWindowTarget.windowId(), WINDOWID_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowTarget.windowTargetId(), WINDOWTARGETID_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowTarget.resourceTypeAsString(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall(maintenanceWindowTarget.targets(), TARGETS_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowTarget.ownerInformation(), OWNERINFORMATION_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowTarget.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)maintenanceWindowTarget.description(), DESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

