/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeAssociationRequestModelMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceId").isBinary(false).build();
    private static final MarshallingInfo<String> ASSOCIATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationId").isBinary(false).build();
    private static final MarshallingInfo<String> ASSOCIATIONVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationVersion").isBinary(false).build();
    private static final DescribeAssociationRequestModelMarshaller INSTANCE = new DescribeAssociationRequestModelMarshaller();

    private DescribeAssociationRequestModelMarshaller() {
    }

    public static DescribeAssociationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeAssociationRequest describeAssociationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeAssociationRequest), (String)"describeAssociationRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeAssociationRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)describeAssociationRequest.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)describeAssociationRequest.associationId(), ASSOCIATIONID_BINDING);
            protocolMarshaller.marshall((Object)describeAssociationRequest.associationVersion(), ASSOCIATIONVERSION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

