/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.ComplianceItemEntry;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ComplianceItemEntryMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> TITLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Title").isBinary(false).build();
    private static final MarshallingInfo<String> SEVERITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Severity").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<Map> DETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Details").isBinary(false).build();
    private static final ComplianceItemEntryMarshaller INSTANCE = new ComplianceItemEntryMarshaller();

    private ComplianceItemEntryMarshaller() {
    }

    public static ComplianceItemEntryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ComplianceItemEntry complianceItemEntry, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)complianceItemEntry, (String)"complianceItemEntry");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)complianceItemEntry.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)complianceItemEntry.title(), TITLE_BINDING);
            protocolMarshaller.marshall((Object)complianceItemEntry.severityAsString(), SEVERITY_BINDING);
            protocolMarshaller.marshall((Object)complianceItemEntry.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall(complianceItemEntry.details(), DETAILS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

