/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.AssociationOverview;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AssociationOverviewMarshaller {
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> DETAILEDSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DetailedStatus").isBinary(false).build();
    private static final MarshallingInfo<Map> ASSOCIATIONSTATUSAGGREGATEDCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AssociationStatusAggregatedCount").isBinary(false).build();
    private static final AssociationOverviewMarshaller INSTANCE = new AssociationOverviewMarshaller();

    private AssociationOverviewMarshaller() {
    }

    public static AssociationOverviewMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AssociationOverview associationOverview, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)associationOverview, (String)"associationOverview");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)associationOverview.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)associationOverview.detailedStatus(), DETAILEDSTATUS_BINDING);
            protocolMarshaller.marshall(associationOverview.associationStatusAggregatedCount(), ASSOCIATIONSTATUSAGGREGATEDCOUNT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

