/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.OperatingSystem;
import software.amazon.awssdk.services.ssm.transform.PatchBaselineIdentityMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PatchBaselineIdentity
implements StructuredPojo,
ToCopyableBuilder<Builder, PatchBaselineIdentity> {
    private final String baselineId;
    private final String baselineName;
    private final String operatingSystem;
    private final String baselineDescription;
    private final Boolean defaultBaseline;

    private PatchBaselineIdentity(BuilderImpl builder) {
        this.baselineId = builder.baselineId;
        this.baselineName = builder.baselineName;
        this.operatingSystem = builder.operatingSystem;
        this.baselineDescription = builder.baselineDescription;
        this.defaultBaseline = builder.defaultBaseline;
    }

    public String baselineId() {
        return this.baselineId;
    }

    public String baselineName() {
        return this.baselineName;
    }

    public OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(this.operatingSystem);
    }

    public String operatingSystemAsString() {
        return this.operatingSystem;
    }

    public String baselineDescription() {
        return this.baselineDescription;
    }

    public Boolean defaultBaseline() {
        return this.defaultBaseline;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultBaseline());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchBaselineIdentity)) {
            return false;
        }
        PatchBaselineIdentity other = (PatchBaselineIdentity)obj;
        return Objects.equals(this.baselineId(), other.baselineId()) && Objects.equals(this.baselineName(), other.baselineName()) && Objects.equals(this.operatingSystemAsString(), other.operatingSystemAsString()) && Objects.equals(this.baselineDescription(), other.baselineDescription()) && Objects.equals(this.defaultBaseline(), other.defaultBaseline());
    }

    public String toString() {
        return ToString.builder((String)"PatchBaselineIdentity").add("BaselineId", (Object)this.baselineId()).add("BaselineName", (Object)this.baselineName()).add("OperatingSystem", (Object)this.operatingSystemAsString()).add("BaselineDescription", (Object)this.baselineDescription()).add("DefaultBaseline", (Object)this.defaultBaseline()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaselineId": {
                return Optional.ofNullable(clazz.cast(this.baselineId()));
            }
            case "BaselineName": {
                return Optional.ofNullable(clazz.cast(this.baselineName()));
            }
            case "OperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemAsString()));
            }
            case "BaselineDescription": {
                return Optional.ofNullable(clazz.cast(this.baselineDescription()));
            }
            case "DefaultBaseline": {
                return Optional.ofNullable(clazz.cast(this.defaultBaseline()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PatchBaselineIdentityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String baselineId;
        private String baselineName;
        private String operatingSystem;
        private String baselineDescription;
        private Boolean defaultBaseline;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchBaselineIdentity model) {
            this.baselineId(model.baselineId);
            this.baselineName(model.baselineName);
            this.operatingSystem(model.operatingSystem);
            this.baselineDescription(model.baselineDescription);
            this.defaultBaseline(model.defaultBaseline);
        }

        public final String getBaselineId() {
            return this.baselineId;
        }

        @Override
        public final Builder baselineId(String baselineId) {
            this.baselineId = baselineId;
            return this;
        }

        public final void setBaselineId(String baselineId) {
            this.baselineId = baselineId;
        }

        public final String getBaselineName() {
            return this.baselineName;
        }

        @Override
        public final Builder baselineName(String baselineName) {
            this.baselineName = baselineName;
            return this;
        }

        public final void setBaselineName(String baselineName) {
            this.baselineName = baselineName;
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem.toString());
            return this;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        public final String getBaselineDescription() {
            return this.baselineDescription;
        }

        @Override
        public final Builder baselineDescription(String baselineDescription) {
            this.baselineDescription = baselineDescription;
            return this;
        }

        public final void setBaselineDescription(String baselineDescription) {
            this.baselineDescription = baselineDescription;
        }

        public final Boolean getDefaultBaseline() {
            return this.defaultBaseline;
        }

        @Override
        public final Builder defaultBaseline(Boolean defaultBaseline) {
            this.defaultBaseline = defaultBaseline;
            return this;
        }

        public final void setDefaultBaseline(Boolean defaultBaseline) {
            this.defaultBaseline = defaultBaseline;
        }

        public PatchBaselineIdentity build() {
            return new PatchBaselineIdentity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PatchBaselineIdentity> {
        public Builder baselineId(String var1);

        public Builder baselineName(String var1);

        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);

        public Builder baselineDescription(String var1);

        public Builder defaultBaseline(Boolean var1);
    }
}

