/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowAutomationParameters;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowLambdaParameters;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowRunCommandParameters;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowStepFunctionsParameters;
import software.amazon.awssdk.services.ssm.transform.MaintenanceWindowTaskInvocationParametersMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MaintenanceWindowTaskInvocationParameters
implements StructuredPojo,
ToCopyableBuilder<Builder, MaintenanceWindowTaskInvocationParameters> {
    private final MaintenanceWindowRunCommandParameters runCommand;
    private final MaintenanceWindowAutomationParameters automation;
    private final MaintenanceWindowStepFunctionsParameters stepFunctions;
    private final MaintenanceWindowLambdaParameters lambda;

    private MaintenanceWindowTaskInvocationParameters(BuilderImpl builder) {
        this.runCommand = builder.runCommand;
        this.automation = builder.automation;
        this.stepFunctions = builder.stepFunctions;
        this.lambda = builder.lambda;
    }

    public MaintenanceWindowRunCommandParameters runCommand() {
        return this.runCommand;
    }

    public MaintenanceWindowAutomationParameters automation() {
        return this.automation;
    }

    public MaintenanceWindowStepFunctionsParameters stepFunctions() {
        return this.stepFunctions;
    }

    public MaintenanceWindowLambdaParameters lambda() {
        return this.lambda;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.runCommand());
        hashCode = 31 * hashCode + Objects.hashCode(this.automation());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepFunctions());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambda());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowTaskInvocationParameters)) {
            return false;
        }
        MaintenanceWindowTaskInvocationParameters other = (MaintenanceWindowTaskInvocationParameters)obj;
        return Objects.equals(this.runCommand(), other.runCommand()) && Objects.equals(this.automation(), other.automation()) && Objects.equals(this.stepFunctions(), other.stepFunctions()) && Objects.equals(this.lambda(), other.lambda());
    }

    public String toString() {
        return ToString.builder((String)"MaintenanceWindowTaskInvocationParameters").add("RunCommand", (Object)this.runCommand()).add("Automation", (Object)this.automation()).add("StepFunctions", (Object)this.stepFunctions()).add("Lambda", (Object)this.lambda()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RunCommand": {
                return Optional.ofNullable(clazz.cast(this.runCommand()));
            }
            case "Automation": {
                return Optional.ofNullable(clazz.cast(this.automation()));
            }
            case "StepFunctions": {
                return Optional.ofNullable(clazz.cast(this.stepFunctions()));
            }
            case "Lambda": {
                return Optional.ofNullable(clazz.cast(this.lambda()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowTaskInvocationParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private MaintenanceWindowRunCommandParameters runCommand;
        private MaintenanceWindowAutomationParameters automation;
        private MaintenanceWindowStepFunctionsParameters stepFunctions;
        private MaintenanceWindowLambdaParameters lambda;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowTaskInvocationParameters model) {
            this.runCommand(model.runCommand);
            this.automation(model.automation);
            this.stepFunctions(model.stepFunctions);
            this.lambda(model.lambda);
        }

        public final MaintenanceWindowRunCommandParameters.Builder getRunCommand() {
            return this.runCommand != null ? this.runCommand.toBuilder() : null;
        }

        @Override
        public final Builder runCommand(MaintenanceWindowRunCommandParameters runCommand) {
            this.runCommand = runCommand;
            return this;
        }

        public final void setRunCommand(MaintenanceWindowRunCommandParameters.BuilderImpl runCommand) {
            this.runCommand = runCommand != null ? runCommand.build() : null;
        }

        public final MaintenanceWindowAutomationParameters.Builder getAutomation() {
            return this.automation != null ? this.automation.toBuilder() : null;
        }

        @Override
        public final Builder automation(MaintenanceWindowAutomationParameters automation) {
            this.automation = automation;
            return this;
        }

        public final void setAutomation(MaintenanceWindowAutomationParameters.BuilderImpl automation) {
            this.automation = automation != null ? automation.build() : null;
        }

        public final MaintenanceWindowStepFunctionsParameters.Builder getStepFunctions() {
            return this.stepFunctions != null ? this.stepFunctions.toBuilder() : null;
        }

        @Override
        public final Builder stepFunctions(MaintenanceWindowStepFunctionsParameters stepFunctions) {
            this.stepFunctions = stepFunctions;
            return this;
        }

        public final void setStepFunctions(MaintenanceWindowStepFunctionsParameters.BuilderImpl stepFunctions) {
            this.stepFunctions = stepFunctions != null ? stepFunctions.build() : null;
        }

        public final MaintenanceWindowLambdaParameters.Builder getLambda() {
            return this.lambda != null ? this.lambda.toBuilder() : null;
        }

        @Override
        public final Builder lambda(MaintenanceWindowLambdaParameters lambda) {
            this.lambda = lambda;
            return this;
        }

        public final void setLambda(MaintenanceWindowLambdaParameters.BuilderImpl lambda) {
            this.lambda = lambda != null ? lambda.build() : null;
        }

        public MaintenanceWindowTaskInvocationParameters build() {
            return new MaintenanceWindowTaskInvocationParameters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MaintenanceWindowTaskInvocationParameters> {
        public Builder runCommand(MaintenanceWindowRunCommandParameters var1);

        default public Builder runCommand(Consumer<MaintenanceWindowRunCommandParameters.Builder> runCommand) {
            return this.runCommand((MaintenanceWindowRunCommandParameters)((MaintenanceWindowRunCommandParameters.Builder)MaintenanceWindowRunCommandParameters.builder().applyMutation(runCommand)).build());
        }

        public Builder automation(MaintenanceWindowAutomationParameters var1);

        default public Builder automation(Consumer<MaintenanceWindowAutomationParameters.Builder> automation) {
            return this.automation((MaintenanceWindowAutomationParameters)((MaintenanceWindowAutomationParameters.Builder)MaintenanceWindowAutomationParameters.builder().applyMutation(automation)).build());
        }

        public Builder stepFunctions(MaintenanceWindowStepFunctionsParameters var1);

        default public Builder stepFunctions(Consumer<MaintenanceWindowStepFunctionsParameters.Builder> stepFunctions) {
            return this.stepFunctions((MaintenanceWindowStepFunctionsParameters)((MaintenanceWindowStepFunctionsParameters.Builder)MaintenanceWindowStepFunctionsParameters.builder().applyMutation(stepFunctions)).build());
        }

        public Builder lambda(MaintenanceWindowLambdaParameters var1);

        default public Builder lambda(Consumer<MaintenanceWindowLambdaParameters.Builder> lambda) {
            return this.lambda((MaintenanceWindowLambdaParameters)((MaintenanceWindowLambdaParameters.Builder)MaintenanceWindowLambdaParameters.builder().applyMutation(lambda)).build());
        }
    }
}

