/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.InstanceInformationFilterKey;
import software.amazon.awssdk.services.ssm.model.InstanceInformationFilterValueSetCopier;
import software.amazon.awssdk.services.ssm.transform.InstanceInformationFilterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceInformationFilter
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceInformationFilter> {
    private final String key;
    private final List<String> valueSet;

    private InstanceInformationFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.valueSet = builder.valueSet;
    }

    public InstanceInformationFilterKey key() {
        return InstanceInformationFilterKey.fromValue(this.key);
    }

    public String keyAsString() {
        return this.key;
    }

    public List<String> valueSet() {
        return this.valueSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueSet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceInformationFilter)) {
            return false;
        }
        InstanceInformationFilter other = (InstanceInformationFilter)obj;
        return Objects.equals(this.keyAsString(), other.keyAsString()) && Objects.equals(this.valueSet(), other.valueSet());
    }

    public String toString() {
        return ToString.builder((String)"InstanceInformationFilter").add("Key", (Object)this.keyAsString()).add("ValueSet", this.valueSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "key": {
                return Optional.ofNullable(clazz.cast(this.keyAsString()));
            }
            case "valueSet": {
                return Optional.ofNullable(clazz.cast(this.valueSet()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceInformationFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private List<String> valueSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceInformationFilter model) {
            this.key(model.key);
            this.valueSet(model.valueSet);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder key(InstanceInformationFilterKey key) {
            this.key(key.toString());
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValueSet() {
            return this.valueSet;
        }

        @Override
        public final Builder valueSet(Collection<String> valueSet) {
            this.valueSet = InstanceInformationFilterValueSetCopier.copy(valueSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueSet(String ... valueSet) {
            this.valueSet(Arrays.asList(valueSet));
            return this;
        }

        public final void setValueSet(Collection<String> valueSet) {
            this.valueSet = InstanceInformationFilterValueSetCopier.copy(valueSet);
        }

        public InstanceInformationFilter build() {
            return new InstanceInformationFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceInformationFilter> {
        public Builder key(String var1);

        public Builder key(InstanceInformationFilterKey var1);

        public Builder valueSet(Collection<String> var1);

        public Builder valueSet(String ... var1);
    }
}

