/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.CreateAssociationBatchRequestEntry;
import software.amazon.awssdk.services.ssm.model.Fault;
import software.amazon.awssdk.services.ssm.transform.FailedCreateAssociationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailedCreateAssociation
implements StructuredPojo,
ToCopyableBuilder<Builder, FailedCreateAssociation> {
    private final CreateAssociationBatchRequestEntry entry;
    private final String message;
    private final String fault;

    private FailedCreateAssociation(BuilderImpl builder) {
        this.entry = builder.entry;
        this.message = builder.message;
        this.fault = builder.fault;
    }

    public CreateAssociationBatchRequestEntry entry() {
        return this.entry;
    }

    public String message() {
        return this.message;
    }

    public Fault fault() {
        return Fault.fromValue(this.fault);
    }

    public String faultAsString() {
        return this.fault;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entry());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.faultAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedCreateAssociation)) {
            return false;
        }
        FailedCreateAssociation other = (FailedCreateAssociation)obj;
        return Objects.equals(this.entry(), other.entry()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.faultAsString(), other.faultAsString());
    }

    public String toString() {
        return ToString.builder((String)"FailedCreateAssociation").add("Entry", (Object)this.entry()).add("Message", (Object)this.message()).add("Fault", (Object)this.faultAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Entry": {
                return Optional.ofNullable(clazz.cast(this.entry()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "Fault": {
                return Optional.ofNullable(clazz.cast(this.faultAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FailedCreateAssociationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private CreateAssociationBatchRequestEntry entry;
        private String message;
        private String fault;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedCreateAssociation model) {
            this.entry(model.entry);
            this.message(model.message);
            this.fault(model.fault);
        }

        public final CreateAssociationBatchRequestEntry.Builder getEntry() {
            return this.entry != null ? this.entry.toBuilder() : null;
        }

        @Override
        public final Builder entry(CreateAssociationBatchRequestEntry entry) {
            this.entry = entry;
            return this;
        }

        public final void setEntry(CreateAssociationBatchRequestEntry.BuilderImpl entry) {
            this.entry = entry != null ? entry.build() : null;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getFault() {
            return this.fault;
        }

        @Override
        public final Builder fault(String fault) {
            this.fault = fault;
            return this;
        }

        @Override
        public final Builder fault(Fault fault) {
            this.fault(fault.toString());
            return this;
        }

        public final void setFault(String fault) {
            this.fault = fault;
        }

        public FailedCreateAssociation build() {
            return new FailedCreateAssociation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FailedCreateAssociation> {
        public Builder entry(CreateAssociationBatchRequestEntry var1);

        default public Builder entry(Consumer<CreateAssociationBatchRequestEntry.Builder> entry) {
            return this.entry((CreateAssociationBatchRequestEntry)((CreateAssociationBatchRequestEntry.Builder)CreateAssociationBatchRequestEntry.builder().applyMutation(entry)).build());
        }

        public Builder message(String var1);

        public Builder fault(String var1);

        public Builder fault(Fault var1);
    }
}

