/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ssm.model.PatchStatus;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PatchStatusMarshaller {
    private static final MarshallingInfo<String> DEPLOYMENTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeploymentStatus").isBinary(false).build();
    private static final MarshallingInfo<String> COMPLIANCELEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComplianceLevel").isBinary(false).build();
    private static final MarshallingInfo<Instant> APPROVALDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApprovalDate").isBinary(false).build();
    private static final PatchStatusMarshaller INSTANCE = new PatchStatusMarshaller();

    private PatchStatusMarshaller() {
    }

    public static PatchStatusMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PatchStatus patchStatus, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)patchStatus, (String)"patchStatus");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)patchStatus.deploymentStatusAsString(), DEPLOYMENTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)patchStatus.complianceLevelAsString(), COMPLIANCELEVEL_BINDING);
            protocolMarshaller.marshall((Object)patchStatus.approvalDate(), APPROVALDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

