/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.ssm.SSMClient;
import software.amazon.awssdk.services.ssm.model.CommandInvocation;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse;

public class ListCommandInvocationsIterable
implements SdkIterable<ListCommandInvocationsResponse> {
    private final SSMClient client;
    private final ListCommandInvocationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCommandInvocationsIterable(SSMClient client, ListCommandInvocationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCommandInvocationsResponseFetcher();
    }

    public Iterator<ListCommandInvocationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<CommandInvocation> commandInvocations() {
        Function<ListCommandInvocationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.commandInvocations() != null) {
                return response.commandInvocations().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListCommandInvocationsIterable resume(ListCommandInvocationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListCommandInvocationsIterable(this.client, (ListCommandInvocationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListCommandInvocationsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListCommandInvocationsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListCommandInvocationsResponseFetcher
    implements SyncPageFetcher<ListCommandInvocationsResponse> {
        private ListCommandInvocationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCommandInvocationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListCommandInvocationsResponse nextPage(ListCommandInvocationsResponse previousPage) {
            if (previousPage == null) {
                return ListCommandInvocationsIterable.this.client.listCommandInvocations(ListCommandInvocationsIterable.this.firstRequest);
            }
            return ListCommandInvocationsIterable.this.client.listCommandInvocations((ListCommandInvocationsRequest)((Object)ListCommandInvocationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

