/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.ssm.SSMClient;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse;

public class GetParametersByPathIterable
implements SdkIterable<GetParametersByPathResponse> {
    private final SSMClient client;
    private final GetParametersByPathRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetParametersByPathIterable(SSMClient client, GetParametersByPathRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetParametersByPathResponseFetcher();
    }

    public Iterator<GetParametersByPathResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final GetParametersByPathIterable resume(GetParametersByPathResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetParametersByPathIterable(this.client, (GetParametersByPathRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetParametersByPathIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetParametersByPathResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetParametersByPathResponseFetcher
    implements SyncPageFetcher<GetParametersByPathResponse> {
        private GetParametersByPathResponseFetcher() {
        }

        public boolean hasNextPage(GetParametersByPathResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetParametersByPathResponse nextPage(GetParametersByPathResponse previousPage) {
            if (previousPage == null) {
                return GetParametersByPathIterable.this.client.getParametersByPath(GetParametersByPathIterable.this.firstRequest);
            }
            return GetParametersByPathIterable.this.client.getParametersByPath((GetParametersByPathRequest)((Object)GetParametersByPathIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

