/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ssm.model.DocumentIdentifier;
import software.amazon.awssdk.services.ssm.model.DocumentIdentifierListCopier;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDocumentsResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, ListDocumentsResponse> {
    private final List<DocumentIdentifier> documentIdentifiers;
    private final String nextToken;

    private ListDocumentsResponse(BuilderImpl builder) {
        super(builder);
        this.documentIdentifiers = builder.documentIdentifiers;
        this.nextToken = builder.nextToken;
    }

    public List<DocumentIdentifier> documentIdentifiers() {
        return this.documentIdentifiers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentIdentifiers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDocumentsResponse)) {
            return false;
        }
        ListDocumentsResponse other = (ListDocumentsResponse)((Object)obj);
        return Objects.equals(this.documentIdentifiers(), other.documentIdentifiers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDocumentsResponse").add("DocumentIdentifiers", this.documentIdentifiers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentIdentifiers": {
                return Optional.of(clazz.cast(this.documentIdentifiers()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private List<DocumentIdentifier> documentIdentifiers;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDocumentsResponse model) {
            super(model);
            this.documentIdentifiers(model.documentIdentifiers);
            this.nextToken(model.nextToken);
        }

        public final Collection<DocumentIdentifier.Builder> getDocumentIdentifiers() {
            return this.documentIdentifiers != null ? (Collection)this.documentIdentifiers.stream().map(DocumentIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder documentIdentifiers(Collection<DocumentIdentifier> documentIdentifiers) {
            this.documentIdentifiers = DocumentIdentifierListCopier.copy(documentIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentIdentifiers(DocumentIdentifier ... documentIdentifiers) {
            this.documentIdentifiers(Arrays.asList(documentIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentIdentifiers(Consumer<DocumentIdentifier.Builder> ... documentIdentifiers) {
            this.documentIdentifiers(Stream.of(documentIdentifiers).map(c -> (DocumentIdentifier)((DocumentIdentifier.Builder)DocumentIdentifier.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDocumentIdentifiers(Collection<DocumentIdentifier.BuilderImpl> documentIdentifiers) {
            this.documentIdentifiers = DocumentIdentifierListCopier.copyFromBuilder(documentIdentifiers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDocumentsResponse build() {
            return new ListDocumentsResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, ListDocumentsResponse> {
        public Builder documentIdentifiers(Collection<DocumentIdentifier> var1);

        public Builder documentIdentifiers(DocumentIdentifier ... var1);

        public Builder documentIdentifiers(Consumer<DocumentIdentifier.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

