/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ssm.model.CommandInvocationStatus;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetCommandInvocationResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, GetCommandInvocationResponse> {
    private final String commandId;
    private final String instanceId;
    private final String comment;
    private final String documentName;
    private final String pluginName;
    private final Integer responseCode;
    private final String executionStartDateTime;
    private final String executionElapsedTime;
    private final String executionEndDateTime;
    private final String status;
    private final String statusDetails;
    private final String standardOutputContent;
    private final String standardOutputUrl;
    private final String standardErrorContent;
    private final String standardErrorUrl;

    private GetCommandInvocationResponse(BuilderImpl builder) {
        super(builder);
        this.commandId = builder.commandId;
        this.instanceId = builder.instanceId;
        this.comment = builder.comment;
        this.documentName = builder.documentName;
        this.pluginName = builder.pluginName;
        this.responseCode = builder.responseCode;
        this.executionStartDateTime = builder.executionStartDateTime;
        this.executionElapsedTime = builder.executionElapsedTime;
        this.executionEndDateTime = builder.executionEndDateTime;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.standardOutputContent = builder.standardOutputContent;
        this.standardOutputUrl = builder.standardOutputUrl;
        this.standardErrorContent = builder.standardErrorContent;
        this.standardErrorUrl = builder.standardErrorUrl;
    }

    public String commandId() {
        return this.commandId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String comment() {
        return this.comment;
    }

    public String documentName() {
        return this.documentName;
    }

    public String pluginName() {
        return this.pluginName;
    }

    public Integer responseCode() {
        return this.responseCode;
    }

    public String executionStartDateTime() {
        return this.executionStartDateTime;
    }

    public String executionElapsedTime() {
        return this.executionElapsedTime;
    }

    public String executionEndDateTime() {
        return this.executionEndDateTime;
    }

    public CommandInvocationStatus status() {
        return CommandInvocationStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public String standardOutputContent() {
        return this.standardOutputContent;
    }

    public String standardOutputUrl() {
        return this.standardOutputUrl;
    }

    public String standardErrorContent() {
        return this.standardErrorContent;
    }

    public String standardErrorUrl() {
        return this.standardErrorUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commandId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginName());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStartDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionElapsedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionEndDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardOutputContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardOutputUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardErrorContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardErrorUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCommandInvocationResponse)) {
            return false;
        }
        GetCommandInvocationResponse other = (GetCommandInvocationResponse)((Object)obj);
        return Objects.equals(this.commandId(), other.commandId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.documentName(), other.documentName()) && Objects.equals(this.pluginName(), other.pluginName()) && Objects.equals(this.responseCode(), other.responseCode()) && Objects.equals(this.executionStartDateTime(), other.executionStartDateTime()) && Objects.equals(this.executionElapsedTime(), other.executionElapsedTime()) && Objects.equals(this.executionEndDateTime(), other.executionEndDateTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.standardOutputContent(), other.standardOutputContent()) && Objects.equals(this.standardOutputUrl(), other.standardOutputUrl()) && Objects.equals(this.standardErrorContent(), other.standardErrorContent()) && Objects.equals(this.standardErrorUrl(), other.standardErrorUrl());
    }

    public String toString() {
        return ToString.builder((String)"GetCommandInvocationResponse").add("CommandId", (Object)this.commandId()).add("InstanceId", (Object)this.instanceId()).add("Comment", (Object)this.comment()).add("DocumentName", (Object)this.documentName()).add("PluginName", (Object)this.pluginName()).add("ResponseCode", (Object)this.responseCode()).add("ExecutionStartDateTime", (Object)this.executionStartDateTime()).add("ExecutionElapsedTime", (Object)this.executionElapsedTime()).add("ExecutionEndDateTime", (Object)this.executionEndDateTime()).add("Status", (Object)this.statusAsString()).add("StatusDetails", (Object)this.statusDetails()).add("StandardOutputContent", (Object)this.standardOutputContent()).add("StandardOutputUrl", (Object)this.standardOutputUrl()).add("StandardErrorContent", (Object)this.standardErrorContent()).add("StandardErrorUrl", (Object)this.standardErrorUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CommandId": {
                return Optional.of(clazz.cast(this.commandId()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "Comment": {
                return Optional.of(clazz.cast(this.comment()));
            }
            case "DocumentName": {
                return Optional.of(clazz.cast(this.documentName()));
            }
            case "PluginName": {
                return Optional.of(clazz.cast(this.pluginName()));
            }
            case "ResponseCode": {
                return Optional.of(clazz.cast(this.responseCode()));
            }
            case "ExecutionStartDateTime": {
                return Optional.of(clazz.cast(this.executionStartDateTime()));
            }
            case "ExecutionElapsedTime": {
                return Optional.of(clazz.cast(this.executionElapsedTime()));
            }
            case "ExecutionEndDateTime": {
                return Optional.of(clazz.cast(this.executionEndDateTime()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusAsString()));
            }
            case "StatusDetails": {
                return Optional.of(clazz.cast(this.statusDetails()));
            }
            case "StandardOutputContent": {
                return Optional.of(clazz.cast(this.standardOutputContent()));
            }
            case "StandardOutputUrl": {
                return Optional.of(clazz.cast(this.standardOutputUrl()));
            }
            case "StandardErrorContent": {
                return Optional.of(clazz.cast(this.standardErrorContent()));
            }
            case "StandardErrorUrl": {
                return Optional.of(clazz.cast(this.standardErrorUrl()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private String commandId;
        private String instanceId;
        private String comment;
        private String documentName;
        private String pluginName;
        private Integer responseCode;
        private String executionStartDateTime;
        private String executionElapsedTime;
        private String executionEndDateTime;
        private String status;
        private String statusDetails;
        private String standardOutputContent;
        private String standardOutputUrl;
        private String standardErrorContent;
        private String standardErrorUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCommandInvocationResponse model) {
            super(model);
            this.commandId(model.commandId);
            this.instanceId(model.instanceId);
            this.comment(model.comment);
            this.documentName(model.documentName);
            this.pluginName(model.pluginName);
            this.responseCode(model.responseCode);
            this.executionStartDateTime(model.executionStartDateTime);
            this.executionElapsedTime(model.executionElapsedTime);
            this.executionEndDateTime(model.executionEndDateTime);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.standardOutputContent(model.standardOutputContent);
            this.standardOutputUrl(model.standardOutputUrl);
            this.standardErrorContent(model.standardErrorContent);
            this.standardErrorUrl(model.standardErrorUrl);
        }

        public final String getCommandId() {
            return this.commandId;
        }

        @Override
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getPluginName() {
            return this.pluginName;
        }

        @Override
        public final Builder pluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        public final void setPluginName(String pluginName) {
            this.pluginName = pluginName;
        }

        public final Integer getResponseCode() {
            return this.responseCode;
        }

        @Override
        public final Builder responseCode(Integer responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final void setResponseCode(Integer responseCode) {
            this.responseCode = responseCode;
        }

        public final String getExecutionStartDateTime() {
            return this.executionStartDateTime;
        }

        @Override
        public final Builder executionStartDateTime(String executionStartDateTime) {
            this.executionStartDateTime = executionStartDateTime;
            return this;
        }

        public final void setExecutionStartDateTime(String executionStartDateTime) {
            this.executionStartDateTime = executionStartDateTime;
        }

        public final String getExecutionElapsedTime() {
            return this.executionElapsedTime;
        }

        @Override
        public final Builder executionElapsedTime(String executionElapsedTime) {
            this.executionElapsedTime = executionElapsedTime;
            return this;
        }

        public final void setExecutionElapsedTime(String executionElapsedTime) {
            this.executionElapsedTime = executionElapsedTime;
        }

        public final String getExecutionEndDateTime() {
            return this.executionEndDateTime;
        }

        @Override
        public final Builder executionEndDateTime(String executionEndDateTime) {
            this.executionEndDateTime = executionEndDateTime;
            return this;
        }

        public final void setExecutionEndDateTime(String executionEndDateTime) {
            this.executionEndDateTime = executionEndDateTime;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CommandInvocationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final String getStandardOutputContent() {
            return this.standardOutputContent;
        }

        @Override
        public final Builder standardOutputContent(String standardOutputContent) {
            this.standardOutputContent = standardOutputContent;
            return this;
        }

        public final void setStandardOutputContent(String standardOutputContent) {
            this.standardOutputContent = standardOutputContent;
        }

        public final String getStandardOutputUrl() {
            return this.standardOutputUrl;
        }

        @Override
        public final Builder standardOutputUrl(String standardOutputUrl) {
            this.standardOutputUrl = standardOutputUrl;
            return this;
        }

        public final void setStandardOutputUrl(String standardOutputUrl) {
            this.standardOutputUrl = standardOutputUrl;
        }

        public final String getStandardErrorContent() {
            return this.standardErrorContent;
        }

        @Override
        public final Builder standardErrorContent(String standardErrorContent) {
            this.standardErrorContent = standardErrorContent;
            return this;
        }

        public final void setStandardErrorContent(String standardErrorContent) {
            this.standardErrorContent = standardErrorContent;
        }

        public final String getStandardErrorUrl() {
            return this.standardErrorUrl;
        }

        @Override
        public final Builder standardErrorUrl(String standardErrorUrl) {
            this.standardErrorUrl = standardErrorUrl;
            return this;
        }

        public final void setStandardErrorUrl(String standardErrorUrl) {
            this.standardErrorUrl = standardErrorUrl;
        }

        @Override
        public GetCommandInvocationResponse build() {
            return new GetCommandInvocationResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, GetCommandInvocationResponse> {
        public Builder commandId(String var1);

        public Builder instanceId(String var1);

        public Builder comment(String var1);

        public Builder documentName(String var1);

        public Builder pluginName(String var1);

        public Builder responseCode(Integer var1);

        public Builder executionStartDateTime(String var1);

        public Builder executionElapsedTime(String var1);

        public Builder executionEndDateTime(String var1);

        public Builder status(String var1);

        public Builder status(CommandInvocationStatus var1);

        public Builder statusDetails(String var1);

        public Builder standardOutputContent(String var1);

        public Builder standardOutputUrl(String var1);

        public Builder standardErrorContent(String var1);

        public Builder standardErrorUrl(String var1);
    }
}

