/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ssm.model.PatchBaselineIdentity;
import software.amazon.awssdk.services.ssm.model.PatchBaselineIdentityListCopier;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePatchBaselinesResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, DescribePatchBaselinesResponse> {
    private final List<PatchBaselineIdentity> baselineIdentities;
    private final String nextToken;

    private DescribePatchBaselinesResponse(BuilderImpl builder) {
        super(builder);
        this.baselineIdentities = builder.baselineIdentities;
        this.nextToken = builder.nextToken;
    }

    public List<PatchBaselineIdentity> baselineIdentities() {
        return this.baselineIdentities;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineIdentities());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePatchBaselinesResponse)) {
            return false;
        }
        DescribePatchBaselinesResponse other = (DescribePatchBaselinesResponse)((Object)obj);
        return Objects.equals(this.baselineIdentities(), other.baselineIdentities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribePatchBaselinesResponse").add("BaselineIdentities", this.baselineIdentities()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaselineIdentities": {
                return Optional.of(clazz.cast(this.baselineIdentities()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private List<PatchBaselineIdentity> baselineIdentities;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePatchBaselinesResponse model) {
            super(model);
            this.baselineIdentities(model.baselineIdentities);
            this.nextToken(model.nextToken);
        }

        public final Collection<PatchBaselineIdentity.Builder> getBaselineIdentities() {
            return this.baselineIdentities != null ? (Collection)this.baselineIdentities.stream().map(PatchBaselineIdentity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder baselineIdentities(Collection<PatchBaselineIdentity> baselineIdentities) {
            this.baselineIdentities = PatchBaselineIdentityListCopier.copy(baselineIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baselineIdentities(PatchBaselineIdentity ... baselineIdentities) {
            this.baselineIdentities(Arrays.asList(baselineIdentities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baselineIdentities(Consumer<PatchBaselineIdentity.Builder> ... baselineIdentities) {
            this.baselineIdentities(Stream.of(baselineIdentities).map(c -> (PatchBaselineIdentity)((PatchBaselineIdentity.Builder)PatchBaselineIdentity.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBaselineIdentities(Collection<PatchBaselineIdentity.BuilderImpl> baselineIdentities) {
            this.baselineIdentities = PatchBaselineIdentityListCopier.copyFromBuilder(baselineIdentities);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribePatchBaselinesResponse build() {
            return new DescribePatchBaselinesResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, DescribePatchBaselinesResponse> {
        public Builder baselineIdentities(Collection<PatchBaselineIdentity> var1);

        public Builder baselineIdentities(PatchBaselineIdentity ... var1);

        public Builder baselineIdentities(Consumer<PatchBaselineIdentity.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

