/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowIdentity;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowIdentityListCopier;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMaintenanceWindowsResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, DescribeMaintenanceWindowsResponse> {
    private final List<MaintenanceWindowIdentity> windowIdentities;
    private final String nextToken;

    private DescribeMaintenanceWindowsResponse(BuilderImpl builder) {
        super(builder);
        this.windowIdentities = builder.windowIdentities;
        this.nextToken = builder.nextToken;
    }

    public List<MaintenanceWindowIdentity> windowIdentities() {
        return this.windowIdentities;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowIdentities());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowsResponse)) {
            return false;
        }
        DescribeMaintenanceWindowsResponse other = (DescribeMaintenanceWindowsResponse)((Object)obj);
        return Objects.equals(this.windowIdentities(), other.windowIdentities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeMaintenanceWindowsResponse").add("WindowIdentities", this.windowIdentities()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowIdentities": {
                return Optional.of(clazz.cast(this.windowIdentities()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private List<MaintenanceWindowIdentity> windowIdentities;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowsResponse model) {
            super(model);
            this.windowIdentities(model.windowIdentities);
            this.nextToken(model.nextToken);
        }

        public final Collection<MaintenanceWindowIdentity.Builder> getWindowIdentities() {
            return this.windowIdentities != null ? (Collection)this.windowIdentities.stream().map(MaintenanceWindowIdentity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder windowIdentities(Collection<MaintenanceWindowIdentity> windowIdentities) {
            this.windowIdentities = MaintenanceWindowIdentityListCopier.copy(windowIdentities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowIdentities(MaintenanceWindowIdentity ... windowIdentities) {
            this.windowIdentities(Arrays.asList(windowIdentities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder windowIdentities(Consumer<MaintenanceWindowIdentity.Builder> ... windowIdentities) {
            this.windowIdentities(Stream.of(windowIdentities).map(c -> (MaintenanceWindowIdentity)((MaintenanceWindowIdentity.Builder)MaintenanceWindowIdentity.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWindowIdentities(Collection<MaintenanceWindowIdentity.BuilderImpl> windowIdentities) {
            this.windowIdentities = MaintenanceWindowIdentityListCopier.copyFromBuilder(windowIdentities);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeMaintenanceWindowsResponse build() {
            return new DescribeMaintenanceWindowsResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, DescribeMaintenanceWindowsResponse> {
        public Builder windowIdentities(Collection<MaintenanceWindowIdentity> var1);

        public Builder windowIdentities(MaintenanceWindowIdentity ... var1);

        public Builder windowIdentities(Consumer<MaintenanceWindowIdentity.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

