/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationStatusInfo;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationStatusInfosCopier;
import software.amazon.awssdk.services.ssm.model.SSMResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstanceAssociationsStatusResponse
extends SSMResponse
implements ToCopyableBuilder<Builder, DescribeInstanceAssociationsStatusResponse> {
    private final List<InstanceAssociationStatusInfo> instanceAssociationStatusInfos;
    private final String nextToken;

    private DescribeInstanceAssociationsStatusResponse(BuilderImpl builder) {
        super(builder);
        this.instanceAssociationStatusInfos = builder.instanceAssociationStatusInfos;
        this.nextToken = builder.nextToken;
    }

    public List<InstanceAssociationStatusInfo> instanceAssociationStatusInfos() {
        return this.instanceAssociationStatusInfos;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceAssociationStatusInfos());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceAssociationsStatusResponse)) {
            return false;
        }
        DescribeInstanceAssociationsStatusResponse other = (DescribeInstanceAssociationsStatusResponse)((Object)obj);
        return Objects.equals(this.instanceAssociationStatusInfos(), other.instanceAssociationStatusInfos()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeInstanceAssociationsStatusResponse").add("InstanceAssociationStatusInfos", this.instanceAssociationStatusInfos()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceAssociationStatusInfos": {
                return Optional.of(clazz.cast(this.instanceAssociationStatusInfos()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SSMResponse.BuilderImpl
    implements Builder {
        private List<InstanceAssociationStatusInfo> instanceAssociationStatusInfos;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceAssociationsStatusResponse model) {
            super(model);
            this.instanceAssociationStatusInfos(model.instanceAssociationStatusInfos);
            this.nextToken(model.nextToken);
        }

        public final Collection<InstanceAssociationStatusInfo.Builder> getInstanceAssociationStatusInfos() {
            return this.instanceAssociationStatusInfos != null ? (Collection)this.instanceAssociationStatusInfos.stream().map(InstanceAssociationStatusInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceAssociationStatusInfos(Collection<InstanceAssociationStatusInfo> instanceAssociationStatusInfos) {
            this.instanceAssociationStatusInfos = InstanceAssociationStatusInfosCopier.copy(instanceAssociationStatusInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceAssociationStatusInfos(InstanceAssociationStatusInfo ... instanceAssociationStatusInfos) {
            this.instanceAssociationStatusInfos(Arrays.asList(instanceAssociationStatusInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceAssociationStatusInfos(Consumer<InstanceAssociationStatusInfo.Builder> ... instanceAssociationStatusInfos) {
            this.instanceAssociationStatusInfos(Stream.of(instanceAssociationStatusInfos).map(c -> (InstanceAssociationStatusInfo)((InstanceAssociationStatusInfo.Builder)InstanceAssociationStatusInfo.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceAssociationStatusInfos(Collection<InstanceAssociationStatusInfo.BuilderImpl> instanceAssociationStatusInfos) {
            this.instanceAssociationStatusInfos = InstanceAssociationStatusInfosCopier.copyFromBuilder(instanceAssociationStatusInfos);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstanceAssociationsStatusResponse build() {
            return new DescribeInstanceAssociationsStatusResponse(this);
        }
    }

    public static interface Builder
    extends SSMResponse.Builder,
    CopyableBuilder<Builder, DescribeInstanceAssociationsStatusResponse> {
        public Builder instanceAssociationStatusInfos(Collection<InstanceAssociationStatusInfo> var1);

        public Builder instanceAssociationStatusInfos(InstanceAssociationStatusInfo ... var1);

        public Builder instanceAssociationStatusInfos(Consumer<InstanceAssociationStatusInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

