/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ssm.model.AssociationOverview;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.services.ssm.transform.AssociationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Association
implements StructuredPojo,
ToCopyableBuilder<Builder, Association> {
    private final String name;
    private final String instanceId;
    private final String associationId;
    private final String associationVersion;
    private final String documentVersion;
    private final List<Target> targets;
    private final Instant lastExecutionDate;
    private final AssociationOverview overview;
    private final String scheduleExpression;
    private final String associationName;

    private Association(BuilderImpl builder) {
        this.name = builder.name;
        this.instanceId = builder.instanceId;
        this.associationId = builder.associationId;
        this.associationVersion = builder.associationVersion;
        this.documentVersion = builder.documentVersion;
        this.targets = builder.targets;
        this.lastExecutionDate = builder.lastExecutionDate;
        this.overview = builder.overview;
        this.scheduleExpression = builder.scheduleExpression;
        this.associationName = builder.associationName;
    }

    public String name() {
        return this.name;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String associationId() {
        return this.associationId;
    }

    public String associationVersion() {
        return this.associationVersion;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public List<Target> targets() {
        return this.targets;
    }

    public Instant lastExecutionDate() {
        return this.lastExecutionDate;
    }

    public AssociationOverview overview() {
        return this.overview;
    }

    public String scheduleExpression() {
        return this.scheduleExpression;
    }

    public String associationName() {
        return this.associationName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastExecutionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.overview());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Association)) {
            return false;
        }
        Association other = (Association)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.associationVersion(), other.associationVersion()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.lastExecutionDate(), other.lastExecutionDate()) && Objects.equals(this.overview(), other.overview()) && Objects.equals(this.scheduleExpression(), other.scheduleExpression()) && Objects.equals(this.associationName(), other.associationName());
    }

    public String toString() {
        return ToString.builder((String)"Association").add("Name", (Object)this.name()).add("InstanceId", (Object)this.instanceId()).add("AssociationId", (Object)this.associationId()).add("AssociationVersion", (Object)this.associationVersion()).add("DocumentVersion", (Object)this.documentVersion()).add("Targets", this.targets()).add("LastExecutionDate", (Object)this.lastExecutionDate()).add("Overview", (Object)this.overview()).add("ScheduleExpression", (Object)this.scheduleExpression()).add("AssociationName", (Object)this.associationName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "AssociationId": {
                return Optional.of(clazz.cast(this.associationId()));
            }
            case "AssociationVersion": {
                return Optional.of(clazz.cast(this.associationVersion()));
            }
            case "DocumentVersion": {
                return Optional.of(clazz.cast(this.documentVersion()));
            }
            case "Targets": {
                return Optional.of(clazz.cast(this.targets()));
            }
            case "LastExecutionDate": {
                return Optional.of(clazz.cast(this.lastExecutionDate()));
            }
            case "Overview": {
                return Optional.of(clazz.cast(this.overview()));
            }
            case "ScheduleExpression": {
                return Optional.of(clazz.cast(this.scheduleExpression()));
            }
            case "AssociationName": {
                return Optional.of(clazz.cast(this.associationName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssociationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String instanceId;
        private String associationId;
        private String associationVersion;
        private String documentVersion;
        private List<Target> targets;
        private Instant lastExecutionDate;
        private AssociationOverview overview;
        private String scheduleExpression;
        private String associationName;

        private BuilderImpl() {
        }

        private BuilderImpl(Association model) {
            this.name(model.name);
            this.instanceId(model.instanceId);
            this.associationId(model.associationId);
            this.associationVersion(model.associationVersion);
            this.documentVersion(model.documentVersion);
            this.targets(model.targets);
            this.lastExecutionDate(model.lastExecutionDate);
            this.overview(model.overview);
            this.scheduleExpression(model.scheduleExpression);
            this.associationName(model.associationName);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getAssociationVersion() {
            return this.associationVersion;
        }

        @Override
        public final Builder associationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
            return this;
        }

        public final void setAssociationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final Collection<Target.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final Instant getLastExecutionDate() {
            return this.lastExecutionDate;
        }

        @Override
        public final Builder lastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
            return this;
        }

        public final void setLastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
        }

        public final AssociationOverview.Builder getOverview() {
            return this.overview != null ? this.overview.toBuilder() : null;
        }

        @Override
        public final Builder overview(AssociationOverview overview) {
            this.overview = overview;
            return this;
        }

        public final void setOverview(AssociationOverview.BuilderImpl overview) {
            this.overview = overview != null ? overview.build() : null;
        }

        public final String getScheduleExpression() {
            return this.scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        public final String getAssociationName() {
            return this.associationName;
        }

        @Override
        public final Builder associationName(String associationName) {
            this.associationName = associationName;
            return this;
        }

        public final void setAssociationName(String associationName) {
            this.associationName = associationName;
        }

        public Association build() {
            return new Association(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Association> {
        public Builder name(String var1);

        public Builder instanceId(String var1);

        public Builder associationId(String var1);

        public Builder associationVersion(String var1);

        public Builder documentVersion(String var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder lastExecutionDate(Instant var1);

        public Builder overview(AssociationOverview var1);

        default public Builder overview(Consumer<AssociationOverview.Builder> overview) {
            return this.overview((AssociationOverview)((AssociationOverview.Builder)AssociationOverview.builder().apply(overview)).build());
        }

        public Builder scheduleExpression(String var1);

        public Builder associationName(String var1);
    }
}

