/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sqs.model.QueueUrlListCopier;
import software.amazon.awssdk.services.sqs.model.SqsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeadLetterSourceQueuesResponse
extends SqsResponse
implements ToCopyableBuilder<Builder, ListDeadLetterSourceQueuesResponse> {
    private static final SdkField<List<String>> QUEUE_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListDeadLetterSourceQueuesResponse.getter(ListDeadLetterSourceQueuesResponse::queueUrls)).setter(ListDeadLetterSourceQueuesResponse.setter(Builder::queueUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueUrl").build(), ListTrait.builder().memberLocationName("QueueUrl").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueUrl").build()}).build()).isFlattened(true).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_URLS_FIELD));
    private final List<String> queueUrls;

    private ListDeadLetterSourceQueuesResponse(BuilderImpl builder) {
        super(builder);
        this.queueUrls = builder.queueUrls;
    }

    public List<String> queueUrls() {
        return this.queueUrls;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queueUrls());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeadLetterSourceQueuesResponse)) {
            return false;
        }
        ListDeadLetterSourceQueuesResponse other = (ListDeadLetterSourceQueuesResponse)((Object)obj);
        return Objects.equals(this.queueUrls(), other.queueUrls());
    }

    public String toString() {
        return ToString.builder((String)"ListDeadLetterSourceQueuesResponse").add("QueueUrls", this.queueUrls()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queueUrls": {
                return Optional.ofNullable(clazz.cast(this.queueUrls()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeadLetterSourceQueuesResponse, T> g) {
        return obj -> g.apply((ListDeadLetterSourceQueuesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SqsResponse.BuilderImpl
    implements Builder {
        private List<String> queueUrls = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeadLetterSourceQueuesResponse model) {
            super(model);
            this.queueUrls(model.queueUrls);
        }

        public final Collection<String> getQueueUrls() {
            return this.queueUrls;
        }

        @Override
        public final Builder queueUrls(Collection<String> queueUrls) {
            this.queueUrls = QueueUrlListCopier.copy(queueUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueUrls(String ... queueUrls) {
            this.queueUrls(Arrays.asList(queueUrls));
            return this;
        }

        public final void setQueueUrls(Collection<String> queueUrls) {
            this.queueUrls = QueueUrlListCopier.copy(queueUrls);
        }

        @Override
        public ListDeadLetterSourceQueuesResponse build() {
            return new ListDeadLetterSourceQueuesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SqsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeadLetterSourceQueuesResponse> {
        public Builder queueUrls(Collection<String> var1);

        public Builder queueUrls(String ... var1);
    }
}

