/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.internal.batchmanager;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.internal.batchmanager.RequestBatchManager;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class QueueAttributesManager {
    private static final List<QueueAttributeName> QUEUE_ATTRIBUTE_NAMES = Arrays.asList(QueueAttributeName.RECEIVE_MESSAGE_WAIT_TIME_SECONDS, QueueAttributeName.VISIBILITY_TIMEOUT);
    private final SqsAsyncClient sqsClient;
    private final String queueUrl;
    private final AtomicReference<CompletableFuture<Map<QueueAttributeName, String>>> queueAttributeMap = new AtomicReference();

    public QueueAttributesManager(SqsAsyncClient sqsClient, String queueUrl) {
        this.sqsClient = sqsClient;
        this.queueUrl = queueUrl;
    }

    public CompletableFuture<Duration> getReceiveMessageTimeout(ReceiveMessageRequest rq, Duration configuredWaitTime) {
        Integer waitTimeSeconds = rq.waitTimeSeconds();
        if (waitTimeSeconds != null) {
            long waitTimeMillis = TimeUnit.SECONDS.toMillis(waitTimeSeconds.intValue());
            return CompletableFuture.completedFuture(Duration.ofMillis(Math.max(configuredWaitTime.toMillis(), waitTimeMillis)));
        }
        CompletableFuture<Map<QueueAttributeName, String>> attributeFuture = this.getAttributeMap();
        CompletionStage resultFuture = attributeFuture.thenApply(attributes -> {
            String waitTimeSecondsStr = (String)attributes.get((Object)QueueAttributeName.RECEIVE_MESSAGE_WAIT_TIME_SECONDS);
            long waitTimeFromSqsMillis = TimeUnit.SECONDS.toMillis(Long.parseLong(waitTimeSecondsStr));
            return Duration.ofMillis(Math.max(configuredWaitTime.toMillis(), waitTimeFromSqsMillis));
        });
        return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)resultFuture, attributeFuture);
    }

    public CompletableFuture<Duration> getVisibilityTimeout() {
        CompletableFuture<Map<QueueAttributeName, String>> attributeFuture = this.getAttributeMap();
        CompletionStage resultFuture = attributeFuture.thenApply(attributes -> {
            String visibilityTimeoutStr = (String)attributes.get((Object)QueueAttributeName.VISIBILITY_TIMEOUT);
            return Duration.ofSeconds(Integer.parseInt(visibilityTimeoutStr));
        });
        return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)resultFuture, attributeFuture);
    }

    private CompletableFuture<Map<QueueAttributeName, String>> getAttributeMap() {
        CompletableFuture<Map<QueueAttributeName, String>> future = this.queueAttributeMap.get();
        if (future == null || future.isCompletedExceptionally()) {
            CompletableFuture<Map<QueueAttributeName, String>> newFuture = new CompletableFuture<Map<QueueAttributeName, String>>();
            if (this.queueAttributeMap.compareAndSet(future, newFuture)) {
                this.fetchQueueAttributes().whenComplete((r, t) -> {
                    if (t != null) {
                        newFuture.completeExceptionally((Throwable)t);
                    } else {
                        newFuture.complete((Map<QueueAttributeName, String>)r);
                    }
                });
                return newFuture;
            }
            newFuture.cancel(true);
            return this.queueAttributeMap.get();
        }
        return future;
    }

    private CompletableFuture<Map<QueueAttributeName, String>> fetchQueueAttributes() {
        GetQueueAttributesRequest request = (GetQueueAttributesRequest)((Object)GetQueueAttributesRequest.builder().queueUrl(this.queueUrl).attributeNames(QUEUE_ATTRIBUTE_NAMES).overrideConfiguration(o -> o.applyMutation(RequestBatchManager.USER_AGENT_APPLIER)).build());
        return this.sqsClient.getQueueAttributes(request).thenApply(response -> {
            Map<QueueAttributeName, String> attributes = response.attributes();
            Validate.notNull((Object)attributes.get((Object)QueueAttributeName.RECEIVE_MESSAGE_WAIT_TIME_SECONDS), (String)((Object)((Object)QueueAttributeName.RECEIVE_MESSAGE_WAIT_TIME_SECONDS) + " attribute is null in SQS."), (Object[])new Object[0]);
            Validate.notNull((Object)attributes.get((Object)QueueAttributeName.VISIBILITY_TIMEOUT), (String)((Object)((Object)QueueAttributeName.VISIBILITY_TIMEOUT) + " attribute is null in SQS."), (Object[])new Object[0]);
            return attributes.entrySet().stream().filter(entry -> QUEUE_ATTRIBUTE_NAMES.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        });
    }
}

