/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.internal.batchmanager;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.sqs.internal.batchmanager.RequestPayloadCalculator;

@SdkInternalApi
public final class BatchingExecutionContext<RequestT, ResponseT> {
    private final RequestT request;
    private final CompletableFuture<ResponseT> response;
    private final Optional<Integer> responsePayloadByteSize;

    public BatchingExecutionContext(RequestT request, CompletableFuture<ResponseT> response) {
        this.request = request;
        this.response = response;
        this.responsePayloadByteSize = RequestPayloadCalculator.calculateMessageSize(request);
    }

    public RequestT request() {
        return this.request;
    }

    public CompletableFuture<ResponseT> response() {
        return this.response;
    }

    public Optional<Integer> responsePayloadByteSize() {
        return this.responsePayloadByteSize;
    }
}

