/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.MessageBodyAttributeMapCopier;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeMapCopier;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Message
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Message> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageId").getter(Message.getter(Message::messageId)).setter(Message.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()}).build();
    private static final SdkField<String> RECEIPT_HANDLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReceiptHandle").getter(Message.getter(Message::receiptHandle)).setter(Message.setter(Builder::receiptHandle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceiptHandle").build()}).build();
    private static final SdkField<String> MD5_OF_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MD5OfBody").getter(Message.getter(Message::md5OfBody)).setter(Message.setter(Builder::md5OfBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MD5OfBody").build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Body").getter(Message.getter(Message::body)).setter(Message.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(Message.getter(Message::attributesAsStrings)).setter(Message.setter(Builder::attributesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).isFlattened(true).build()}).build();
    private static final SdkField<String> MD5_OF_MESSAGE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MD5OfMessageAttributes").getter(Message.getter(Message::md5OfMessageAttributes)).setter(Message.setter(Builder::md5OfMessageAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MD5OfMessageAttributes").build()}).build();
    private static final SdkField<Map<String, MessageAttributeValue>> MESSAGE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("MessageAttributes").getter(Message.getter(Message::messageAttributes)).setter(Message.setter(Builder::messageAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).isFlattened(true).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD, RECEIPT_HANDLE_FIELD, MD5_OF_BODY_FIELD, BODY_FIELD, ATTRIBUTES_FIELD, MD5_OF_MESSAGE_ATTRIBUTES_FIELD, MESSAGE_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MessageId", MESSAGE_ID_FIELD);
            this.put("ReceiptHandle", RECEIPT_HANDLE_FIELD);
            this.put("MD5OfBody", MD5_OF_BODY_FIELD);
            this.put("Body", BODY_FIELD);
            this.put("Attributes", ATTRIBUTES_FIELD);
            this.put("MD5OfMessageAttributes", MD5_OF_MESSAGE_ATTRIBUTES_FIELD);
            this.put("MessageAttributes", MESSAGE_ATTRIBUTES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String messageId;
    private final String receiptHandle;
    private final String md5OfBody;
    private final String body;
    private final Map<String, String> attributes;
    private final String md5OfMessageAttributes;
    private final Map<String, MessageAttributeValue> messageAttributes;

    private Message(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.receiptHandle = builder.receiptHandle;
        this.md5OfBody = builder.md5OfBody;
        this.body = builder.body;
        this.attributes = builder.attributes;
        this.md5OfMessageAttributes = builder.md5OfMessageAttributes;
        this.messageAttributes = builder.messageAttributes;
    }

    public final String messageId() {
        return this.messageId;
    }

    public final String receiptHandle() {
        return this.receiptHandle;
    }

    public final String md5OfBody() {
        return this.md5OfBody;
    }

    public final String body() {
        return this.body;
    }

    public final Map<MessageSystemAttributeName, String> attributes() {
        return MessageSystemAttributeMapCopier.copyStringToEnum(this.attributes);
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributesAsStrings() {
        return this.attributes;
    }

    public final String md5OfMessageAttributes() {
        return this.md5OfMessageAttributes;
    }

    public final boolean hasMessageAttributes() {
        return this.messageAttributes != null && !(this.messageAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, MessageAttributeValue> messageAttributes() {
        return this.messageAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.receiptHandle());
        hashCode = 31 * hashCode + Objects.hashCode(this.md5OfBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.md5OfMessageAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessageAttributes() ? this.messageAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        return Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.receiptHandle(), other.receiptHandle()) && Objects.equals(this.md5OfBody(), other.md5OfBody()) && Objects.equals(this.body(), other.body()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributesAsStrings(), other.attributesAsStrings()) && Objects.equals(this.md5OfMessageAttributes(), other.md5OfMessageAttributes()) && this.hasMessageAttributes() == other.hasMessageAttributes() && Objects.equals(this.messageAttributes(), other.messageAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"Message").add("MessageId", (Object)this.messageId()).add("ReceiptHandle", (Object)this.receiptHandle()).add("MD5OfBody", (Object)this.md5OfBody()).add("Body", (Object)this.body()).add("Attributes", this.hasAttributes() ? this.attributesAsStrings() : null).add("MD5OfMessageAttributes", (Object)this.md5OfMessageAttributes()).add("MessageAttributes", this.hasMessageAttributes() ? this.messageAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MessageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "ReceiptHandle": {
                return Optional.ofNullable(clazz.cast(this.receiptHandle()));
            }
            case "MD5OfBody": {
                return Optional.ofNullable(clazz.cast(this.md5OfBody()));
            }
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributesAsStrings()));
            }
            case "MD5OfMessageAttributes": {
                return Optional.ofNullable(clazz.cast(this.md5OfMessageAttributes()));
            }
            case "MessageAttributes": {
                return Optional.ofNullable(clazz.cast(this.messageAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Message, T> g) {
        return obj -> g.apply((Message)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String messageId;
        private String receiptHandle;
        private String md5OfBody;
        private String body;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String md5OfMessageAttributes;
        private Map<String, MessageAttributeValue> messageAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            this.messageId(model.messageId);
            this.receiptHandle(model.receiptHandle);
            this.md5OfBody(model.md5OfBody);
            this.body(model.body);
            this.attributesWithStrings(model.attributes);
            this.md5OfMessageAttributes(model.md5OfMessageAttributes);
            this.messageAttributes(model.messageAttributes);
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getReceiptHandle() {
            return this.receiptHandle;
        }

        public final void setReceiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
        }

        @Override
        public final Builder receiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
            return this;
        }

        public final String getMd5OfBody() {
            return this.md5OfBody;
        }

        public final void setMd5OfBody(String md5OfBody) {
            this.md5OfBody = md5OfBody;
        }

        @Override
        public final Builder md5OfBody(String md5OfBody) {
            this.md5OfBody = md5OfBody;
            return this;
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MessageSystemAttributeMapCopier.copy(attributes);
        }

        @Override
        public final Builder attributesWithStrings(Map<String, String> attributes) {
            this.attributes = MessageSystemAttributeMapCopier.copy(attributes);
            return this;
        }

        @Override
        public final Builder attributes(Map<MessageSystemAttributeName, String> attributes) {
            this.attributes = MessageSystemAttributeMapCopier.copyEnumToString(attributes);
            return this;
        }

        public final String getMd5OfMessageAttributes() {
            return this.md5OfMessageAttributes;
        }

        public final void setMd5OfMessageAttributes(String md5OfMessageAttributes) {
            this.md5OfMessageAttributes = md5OfMessageAttributes;
        }

        @Override
        public final Builder md5OfMessageAttributes(String md5OfMessageAttributes) {
            this.md5OfMessageAttributes = md5OfMessageAttributes;
            return this;
        }

        public final Map<String, MessageAttributeValue.Builder> getMessageAttributes() {
            Map<String, MessageAttributeValue.Builder> result = MessageBodyAttributeMapCopier.copyToBuilder(this.messageAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMessageAttributes(Map<String, MessageAttributeValue.BuilderImpl> messageAttributes) {
            this.messageAttributes = MessageBodyAttributeMapCopier.copyFromBuilder(messageAttributes);
        }

        @Override
        public final Builder messageAttributes(Map<String, MessageAttributeValue> messageAttributes) {
            this.messageAttributes = MessageBodyAttributeMapCopier.copy(messageAttributes);
            return this;
        }

        public Message build() {
            return new Message(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Message> {
        public Builder messageId(String var1);

        public Builder receiptHandle(String var1);

        public Builder md5OfBody(String var1);

        public Builder body(String var1);

        public Builder attributesWithStrings(Map<String, String> var1);

        public Builder attributes(Map<MessageSystemAttributeName, String> var1);

        public Builder md5OfMessageAttributes(String var1);

        public Builder messageAttributes(Map<String, MessageAttributeValue> var1);
    }
}

