/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.internal.UserAgentUtils;
import software.amazon.awssdk.services.sqs.model.ListQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListQueuesResponse;

public class ListQueuesIterable
implements SdkIterable<ListQueuesResponse> {
    private final SqsClient client;
    private final ListQueuesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListQueuesIterable(SqsClient client, ListQueuesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListQueuesResponseFetcher();
    }

    public Iterator<ListQueuesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> queueUrls() {
        Function<ListQueuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.queueUrls() != null) {
                return response.queueUrls().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListQueuesResponseFetcher
    implements SyncPageFetcher<ListQueuesResponse> {
        private ListQueuesResponseFetcher() {
        }

        public boolean hasNextPage(ListQueuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListQueuesResponse nextPage(ListQueuesResponse previousPage) {
            if (previousPage == null) {
                return ListQueuesIterable.this.client.listQueues(ListQueuesIterable.this.firstRequest);
            }
            return ListQueuesIterable.this.client.listQueues((ListQueuesRequest)((Object)ListQueuesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

