/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sqs.model.SqsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQueuesRequest
extends SqsRequest
implements ToCopyableBuilder<Builder, ListQueuesRequest> {
    private static final SdkField<String> QUEUE_NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListQueuesRequest.getter(ListQueuesRequest::queueNamePrefix)).setter(ListQueuesRequest.setter(Builder::queueNamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueNamePrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_NAME_PREFIX_FIELD));
    private final String queueNamePrefix;

    private ListQueuesRequest(BuilderImpl builder) {
        super(builder);
        this.queueNamePrefix = builder.queueNamePrefix;
    }

    public String queueNamePrefix() {
        return this.queueNamePrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queueNamePrefix());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueuesRequest)) {
            return false;
        }
        ListQueuesRequest other = (ListQueuesRequest)((Object)obj);
        return Objects.equals(this.queueNamePrefix(), other.queueNamePrefix());
    }

    public String toString() {
        return ToString.builder((String)"ListQueuesRequest").add("QueueNamePrefix", (Object)this.queueNamePrefix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.queueNamePrefix()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQueuesRequest, T> g) {
        return obj -> g.apply((ListQueuesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SqsRequest.BuilderImpl
    implements Builder {
        private String queueNamePrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueuesRequest model) {
            super(model);
            this.queueNamePrefix(model.queueNamePrefix);
        }

        public final String getQueueNamePrefix() {
            return this.queueNamePrefix;
        }

        @Override
        public final Builder queueNamePrefix(String queueNamePrefix) {
            this.queueNamePrefix = queueNamePrefix;
            return this;
        }

        public final void setQueueNamePrefix(String queueNamePrefix) {
            this.queueNamePrefix = queueNamePrefix;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListQueuesRequest build() {
            return new ListQueuesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SqsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQueuesRequest> {
        public Builder queueNamePrefix(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

