/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sqs.model.AWSAccountIdListCopier;
import software.amazon.awssdk.services.sqs.model.ActionNameListCopier;
import software.amazon.awssdk.services.sqs.model.SqsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddPermissionRequest
extends SqsRequest
implements ToCopyableBuilder<Builder, AddPermissionRequest> {
    private static final SdkField<String> QUEUE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddPermissionRequest.getter(AddPermissionRequest::queueUrl)).setter(AddPermissionRequest.setter(Builder::queueUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueUrl").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddPermissionRequest.getter(AddPermissionRequest::label)).setter(AddPermissionRequest.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final SdkField<List<String>> AWS_ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AddPermissionRequest.getter(AddPermissionRequest::awsAccountIds)).setter(AddPermissionRequest.setter(Builder::awsAccountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSAccountId").build(), ListTrait.builder().memberLocationName("AWSAccountId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSAccountId").build()}).build()).isFlattened(true).build()}).build();
    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AddPermissionRequest.getter(AddPermissionRequest::actions)).setter(AddPermissionRequest.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionName").build(), ListTrait.builder().memberLocationName("ActionName").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionName").build()}).build()).isFlattened(true).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_URL_FIELD, LABEL_FIELD, AWS_ACCOUNT_IDS_FIELD, ACTIONS_FIELD));
    private final String queueUrl;
    private final String label;
    private final List<String> awsAccountIds;
    private final List<String> actions;

    private AddPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.label = builder.label;
        this.awsAccountIds = builder.awsAccountIds;
        this.actions = builder.actions;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    public String label() {
        return this.label;
    }

    public List<String> awsAccountIds() {
        return this.awsAccountIds;
    }

    public List<String> actions() {
        return this.actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.actions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddPermissionRequest)) {
            return false;
        }
        AddPermissionRequest other = (AddPermissionRequest)((Object)obj);
        return Objects.equals(this.queueUrl(), other.queueUrl()) && Objects.equals(this.label(), other.label()) && Objects.equals(this.awsAccountIds(), other.awsAccountIds()) && Objects.equals(this.actions(), other.actions());
    }

    public String toString() {
        return ToString.builder((String)"AddPermissionRequest").add("QueueUrl", (Object)this.queueUrl()).add("Label", (Object)this.label()).add("AWSAccountIds", this.awsAccountIds()).add("Actions", this.actions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueUrl": {
                return Optional.ofNullable(clazz.cast(this.queueUrl()));
            }
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "AWSAccountIds": {
                return Optional.ofNullable(clazz.cast(this.awsAccountIds()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddPermissionRequest, T> g) {
        return obj -> g.apply((AddPermissionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SqsRequest.BuilderImpl
    implements Builder {
        private String queueUrl;
        private String label;
        private List<String> awsAccountIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddPermissionRequest model) {
            super(model);
            this.queueUrl(model.queueUrl);
            this.label(model.label);
            this.awsAccountIds(model.awsAccountIds);
            this.actions(model.actions);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final String getLabel() {
            return this.label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final Collection<String> getAWSAccountIds() {
            return this.awsAccountIds;
        }

        @Override
        public final Builder awsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = AWSAccountIdListCopier.copy(awsAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccountIds(String ... awsAccountIds) {
            this.awsAccountIds(Arrays.asList(awsAccountIds));
            return this;
        }

        public final void setAWSAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = AWSAccountIdListCopier.copy(awsAccountIds);
        }

        public final Collection<String> getActions() {
            return this.actions;
        }

        @Override
        public final Builder actions(Collection<String> actions) {
            this.actions = ActionNameListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(String ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = ActionNameListCopier.copy(actions);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddPermissionRequest build() {
            return new AddPermissionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SqsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddPermissionRequest> {
        public Builder queueUrl(String var1);

        public Builder label(String var1);

        public Builder awsAccountIds(Collection<String> var1);

        public Builder awsAccountIds(String ... var1);

        public Builder actions(Collection<String> var1);

        public Builder actions(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

