/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.sqs.model.BatchResultErrorEntry;
import software.amazon.awssdk.services.sqs.model.BatchResultErrorEntryListCopier;
import software.amazon.awssdk.services.sqs.model.SQSResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResultEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResultEntryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SendMessageBatchResponse
extends SQSResponse
implements ToCopyableBuilder<Builder, SendMessageBatchResponse> {
    private final List<SendMessageBatchResultEntry> successful;
    private final List<BatchResultErrorEntry> failed;

    private SendMessageBatchResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.failed = builder.failed;
    }

    public List<SendMessageBatchResultEntry> successful() {
        return this.successful;
    }

    public List<BatchResultErrorEntry> failed() {
        return this.failed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.successful());
        hashCode = 31 * hashCode + Objects.hashCode(this.failed());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageBatchResponse)) {
            return false;
        }
        SendMessageBatchResponse other = (SendMessageBatchResponse)((Object)obj);
        return Objects.equals(this.successful(), other.successful()) && Objects.equals(this.failed(), other.failed());
    }

    public String toString() {
        return ToString.builder((String)"SendMessageBatchResponse").add("Successful", this.successful()).add("Failed", this.failed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Successful": {
                return Optional.of(clazz.cast(this.successful()));
            }
            case "Failed": {
                return Optional.of(clazz.cast(this.failed()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SQSResponse.BuilderImpl
    implements Builder {
        private List<SendMessageBatchResultEntry> successful;
        private List<BatchResultErrorEntry> failed;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageBatchResponse model) {
            this.successful(model.successful);
            this.failed(model.failed);
        }

        public final Collection<SendMessageBatchResultEntry.Builder> getSuccessful() {
            return this.successful != null ? (Collection)this.successful.stream().map(SendMessageBatchResultEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successful(Collection<SendMessageBatchResultEntry> successful) {
            this.successful = SendMessageBatchResultEntryListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(SendMessageBatchResultEntry ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        public final void setSuccessful(Collection<SendMessageBatchResultEntry.BuilderImpl> successful) {
            this.successful = SendMessageBatchResultEntryListCopier.copyFromBuilder(successful);
        }

        public final Collection<BatchResultErrorEntry.Builder> getFailed() {
            return this.failed != null ? (Collection)this.failed.stream().map(BatchResultErrorEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failed(Collection<BatchResultErrorEntry> failed) {
            this.failed = BatchResultErrorEntryListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchResultErrorEntry ... failed) {
            this.failed(Arrays.asList(failed));
            return this;
        }

        public final void setFailed(Collection<BatchResultErrorEntry.BuilderImpl> failed) {
            this.failed = BatchResultErrorEntryListCopier.copyFromBuilder(failed);
        }

        @Override
        public SendMessageBatchResponse build() {
            return new SendMessageBatchResponse(this);
        }
    }

    public static interface Builder
    extends SQSResponse.Builder,
    CopyableBuilder<Builder, SendMessageBatchResponse> {
        public Builder successful(Collection<SendMessageBatchResultEntry> var1);

        public Builder successful(SendMessageBatchResultEntry ... var1);

        public Builder failed(Collection<BatchResultErrorEntry> var1);

        public Builder failed(BatchResultErrorEntry ... var1);
    }
}

