/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;

public class ReceiveMessageRequestMarshaller
implements Marshaller<Request<ReceiveMessageRequest>, ReceiveMessageRequest> {
    public Request<ReceiveMessageRequest> marshall(ReceiveMessageRequest receiveMessageRequest) {
        List<String> messageAttributeNamesList;
        List<String> attributeNamesList;
        if (receiveMessageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)receiveMessageRequest, "SQSClient");
        request.addParameter("Action", "ReceiveMessage");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (receiveMessageRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)receiveMessageRequest.queueUrl()));
        }
        if ((attributeNamesList = receiveMessageRequest.attributeNamesStrings()) != null) {
            if (!attributeNamesList.isEmpty()) {
                int attributeNamesListIndex = 1;
                for (String attributeNamesListValue : attributeNamesList) {
                    if (attributeNamesListValue != null) {
                        request.addParameter("AttributeName." + attributeNamesListIndex, StringUtils.fromString((String)attributeNamesListValue));
                    }
                    ++attributeNamesListIndex;
                }
            } else {
                request.addParameter("AttributeName", "");
            }
        }
        if ((messageAttributeNamesList = receiveMessageRequest.messageAttributeNames()) != null) {
            if (!messageAttributeNamesList.isEmpty()) {
                int messageAttributeNamesListIndex = 1;
                for (String messageAttributeNamesListValue : messageAttributeNamesList) {
                    if (messageAttributeNamesListValue != null) {
                        request.addParameter("MessageAttributeName." + messageAttributeNamesListIndex, StringUtils.fromString((String)messageAttributeNamesListValue));
                    }
                    ++messageAttributeNamesListIndex;
                }
            } else {
                request.addParameter("MessageAttributeName", "");
            }
        }
        if (receiveMessageRequest.maxNumberOfMessages() != null) {
            request.addParameter("MaxNumberOfMessages", StringUtils.fromInteger((Integer)receiveMessageRequest.maxNumberOfMessages()));
        }
        if (receiveMessageRequest.visibilityTimeout() != null) {
            request.addParameter("VisibilityTimeout", StringUtils.fromInteger((Integer)receiveMessageRequest.visibilityTimeout()));
        }
        if (receiveMessageRequest.waitTimeSeconds() != null) {
            request.addParameter("WaitTimeSeconds", StringUtils.fromInteger((Integer)receiveMessageRequest.waitTimeSeconds()));
        }
        if (receiveMessageRequest.receiveRequestAttemptId() != null) {
            request.addParameter("ReceiveRequestAttemptId", StringUtils.fromString((String)receiveMessageRequest.receiveRequestAttemptId()));
        }
        return request;
    }
}

