/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SendMessageResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, SendMessageResponse> {
    private final String md5OfMessageBody;
    private final String md5OfMessageAttributes;
    private final String messageId;
    private final String sequenceNumber;

    private SendMessageResponse(BuilderImpl builder) {
        this.md5OfMessageBody = builder.md5OfMessageBody;
        this.md5OfMessageAttributes = builder.md5OfMessageAttributes;
        this.messageId = builder.messageId;
        this.sequenceNumber = builder.sequenceNumber;
    }

    public String md5OfMessageBody() {
        return this.md5OfMessageBody;
    }

    public String md5OfMessageAttributes() {
        return this.md5OfMessageAttributes;
    }

    public String messageId() {
        return this.messageId;
    }

    public String sequenceNumber() {
        return this.sequenceNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.md5OfMessageBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.md5OfMessageAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageResponse)) {
            return false;
        }
        SendMessageResponse other = (SendMessageResponse)((Object)obj);
        return Objects.equals(this.md5OfMessageBody(), other.md5OfMessageBody()) && Objects.equals(this.md5OfMessageAttributes(), other.md5OfMessageAttributes()) && Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.sequenceNumber(), other.sequenceNumber());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.md5OfMessageBody() != null) {
            sb.append("MD5OfMessageBody: ").append(this.md5OfMessageBody()).append(",");
        }
        if (this.md5OfMessageAttributes() != null) {
            sb.append("MD5OfMessageAttributes: ").append(this.md5OfMessageAttributes()).append(",");
        }
        if (this.messageId() != null) {
            sb.append("MessageId: ").append(this.messageId()).append(",");
        }
        if (this.sequenceNumber() != null) {
            sb.append("SequenceNumber: ").append(this.sequenceNumber()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MD5OfMessageBody": {
                return Optional.of(clazz.cast(this.md5OfMessageBody()));
            }
            case "MD5OfMessageAttributes": {
                return Optional.of(clazz.cast(this.md5OfMessageAttributes()));
            }
            case "MessageId": {
                return Optional.of(clazz.cast(this.messageId()));
            }
            case "SequenceNumber": {
                return Optional.of(clazz.cast(this.sequenceNumber()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String md5OfMessageBody;
        private String md5OfMessageAttributes;
        private String messageId;
        private String sequenceNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageResponse model) {
            this.md5OfMessageBody(model.md5OfMessageBody);
            this.md5OfMessageAttributes(model.md5OfMessageAttributes);
            this.messageId(model.messageId);
            this.sequenceNumber(model.sequenceNumber);
        }

        public final String getMD5OfMessageBody() {
            return this.md5OfMessageBody;
        }

        @Override
        public final Builder md5OfMessageBody(String md5OfMessageBody) {
            this.md5OfMessageBody = md5OfMessageBody;
            return this;
        }

        public final void setMD5OfMessageBody(String md5OfMessageBody) {
            this.md5OfMessageBody = md5OfMessageBody;
        }

        public final String getMD5OfMessageAttributes() {
            return this.md5OfMessageAttributes;
        }

        @Override
        public final Builder md5OfMessageAttributes(String md5OfMessageAttributes) {
            this.md5OfMessageAttributes = md5OfMessageAttributes;
            return this;
        }

        public final void setMD5OfMessageAttributes(String md5OfMessageAttributes) {
            this.md5OfMessageAttributes = md5OfMessageAttributes;
        }

        public final String getMessageId() {
            return this.messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public final String getSequenceNumber() {
            return this.sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public SendMessageResponse build() {
            return new SendMessageResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SendMessageResponse> {
        public Builder md5OfMessageBody(String var1);

        public Builder md5OfMessageAttributes(String var1);

        public Builder messageId(String var1);

        public Builder sequenceNumber(String var1);
    }
}

