/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.sqs.model.QueueAttributeMapCopier;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateQueueRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateQueueRequest> {
    private final String queueName;
    private final Map<String, String> attributes;

    private CreateQueueRequest(BuilderImpl builder) {
        this.queueName = builder.queueName;
        this.attributes = builder.attributes;
    }

    public String queueName() {
        return this.queueName;
    }

    public Map<QueueAttributeName, String> attributes() {
        return TypeConverter.convert(this.attributes, QueueAttributeName::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)QueueAttributeName.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, String> attributesStrings() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queueName());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributesStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQueueRequest)) {
            return false;
        }
        CreateQueueRequest other = (CreateQueueRequest)((Object)obj);
        return Objects.equals(this.queueName(), other.queueName()) && Objects.equals(this.attributesStrings(), other.attributesStrings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.queueName() != null) {
            sb.append("QueueName: ").append(this.queueName()).append(",");
        }
        if (this.attributesStrings() != null) {
            sb.append("Attributes: ").append(this.attributesStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueName": {
                return Optional.of(clazz.cast(this.queueName()));
            }
            case "Attributes": {
                return Optional.of(clazz.cast(this.attributesStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String queueName;
        private Map<String, String> attributes;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQueueRequest model) {
            this.queueName(model.queueName);
            this.attributes(model.attributes);
        }

        public final String getQueueName() {
            return this.queueName;
        }

        @Override
        public final Builder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public final void setQueueName(String queueName) {
            this.queueName = queueName;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = QueueAttributeMapCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = QueueAttributeMapCopier.copy(attributes);
        }

        public CreateQueueRequest build() {
            return new CreateQueueRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateQueueRequest> {
        public Builder queueName(String var1);

        public Builder attributes(Map<String, String> var1);
    }
}

