/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sqs.model.ListQueuesRequest;
import software.amazon.awssdk.util.StringUtils;

public class ListQueuesRequestMarshaller
implements Marshaller<Request<ListQueuesRequest>, ListQueuesRequest> {
    public Request<ListQueuesRequest> marshall(ListQueuesRequest listQueuesRequest) {
        if (listQueuesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listQueuesRequest, "SQSClient");
        request.addParameter("Action", "ListQueues");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (listQueuesRequest.queueNamePrefix() != null) {
            request.addParameter("QueueNamePrefix", StringUtils.fromString((String)listQueuesRequest.queueNamePrefix()));
        }
        return request;
    }
}

