/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.sqs.model.AttributeNameListCopier;
import software.amazon.awssdk.services.sqs.model.MessageAttributeNameListCopier;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReceiveMessageRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ReceiveMessageRequest> {
    private final String queueUrl;
    private final List<String> attributeNames;
    private final List<String> messageAttributeNames;
    private final Integer maxNumberOfMessages;
    private final Integer visibilityTimeout;
    private final Integer waitTimeSeconds;
    private final String receiveRequestAttemptId;

    private ReceiveMessageRequest(BuilderImpl builder) {
        this.queueUrl = builder.queueUrl;
        this.attributeNames = builder.attributeNames;
        this.messageAttributeNames = builder.messageAttributeNames;
        this.maxNumberOfMessages = builder.maxNumberOfMessages;
        this.visibilityTimeout = builder.visibilityTimeout;
        this.waitTimeSeconds = builder.waitTimeSeconds;
        this.receiveRequestAttemptId = builder.receiveRequestAttemptId;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    public List<String> attributeNames() {
        return this.attributeNames;
    }

    public List<String> messageAttributeNames() {
        return this.messageAttributeNames;
    }

    public Integer maxNumberOfMessages() {
        return this.maxNumberOfMessages;
    }

    public Integer visibilityTimeout() {
        return this.visibilityTimeout;
    }

    public Integer waitTimeSeconds() {
        return this.waitTimeSeconds;
    }

    public String receiveRequestAttemptId() {
        return this.receiveRequestAttemptId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.queueUrl() == null ? 0 : this.queueUrl().hashCode());
        hashCode = 31 * hashCode + (this.attributeNames() == null ? 0 : this.attributeNames().hashCode());
        hashCode = 31 * hashCode + (this.messageAttributeNames() == null ? 0 : this.messageAttributeNames().hashCode());
        hashCode = 31 * hashCode + (this.maxNumberOfMessages() == null ? 0 : this.maxNumberOfMessages().hashCode());
        hashCode = 31 * hashCode + (this.visibilityTimeout() == null ? 0 : this.visibilityTimeout().hashCode());
        hashCode = 31 * hashCode + (this.waitTimeSeconds() == null ? 0 : this.waitTimeSeconds().hashCode());
        hashCode = 31 * hashCode + (this.receiveRequestAttemptId() == null ? 0 : this.receiveRequestAttemptId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiveMessageRequest)) {
            return false;
        }
        ReceiveMessageRequest other = (ReceiveMessageRequest)((Object)obj);
        if (other.queueUrl() == null ^ this.queueUrl() == null) {
            return false;
        }
        if (other.queueUrl() != null && !other.queueUrl().equals(this.queueUrl())) {
            return false;
        }
        if (other.attributeNames() == null ^ this.attributeNames() == null) {
            return false;
        }
        if (other.attributeNames() != null && !other.attributeNames().equals(this.attributeNames())) {
            return false;
        }
        if (other.messageAttributeNames() == null ^ this.messageAttributeNames() == null) {
            return false;
        }
        if (other.messageAttributeNames() != null && !other.messageAttributeNames().equals(this.messageAttributeNames())) {
            return false;
        }
        if (other.maxNumberOfMessages() == null ^ this.maxNumberOfMessages() == null) {
            return false;
        }
        if (other.maxNumberOfMessages() != null && !other.maxNumberOfMessages().equals(this.maxNumberOfMessages())) {
            return false;
        }
        if (other.visibilityTimeout() == null ^ this.visibilityTimeout() == null) {
            return false;
        }
        if (other.visibilityTimeout() != null && !other.visibilityTimeout().equals(this.visibilityTimeout())) {
            return false;
        }
        if (other.waitTimeSeconds() == null ^ this.waitTimeSeconds() == null) {
            return false;
        }
        if (other.waitTimeSeconds() != null && !other.waitTimeSeconds().equals(this.waitTimeSeconds())) {
            return false;
        }
        if (other.receiveRequestAttemptId() == null ^ this.receiveRequestAttemptId() == null) {
            return false;
        }
        return other.receiveRequestAttemptId() == null || other.receiveRequestAttemptId().equals(this.receiveRequestAttemptId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.queueUrl() != null) {
            sb.append("QueueUrl: ").append(this.queueUrl()).append(",");
        }
        if (this.attributeNames() != null) {
            sb.append("AttributeNames: ").append(this.attributeNames()).append(",");
        }
        if (this.messageAttributeNames() != null) {
            sb.append("MessageAttributeNames: ").append(this.messageAttributeNames()).append(",");
        }
        if (this.maxNumberOfMessages() != null) {
            sb.append("MaxNumberOfMessages: ").append(this.maxNumberOfMessages()).append(",");
        }
        if (this.visibilityTimeout() != null) {
            sb.append("VisibilityTimeout: ").append(this.visibilityTimeout()).append(",");
        }
        if (this.waitTimeSeconds() != null) {
            sb.append("WaitTimeSeconds: ").append(this.waitTimeSeconds()).append(",");
        }
        if (this.receiveRequestAttemptId() != null) {
            sb.append("ReceiveRequestAttemptId: ").append(this.receiveRequestAttemptId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String queueUrl;
        private List<String> attributeNames;
        private List<String> messageAttributeNames;
        private Integer maxNumberOfMessages;
        private Integer visibilityTimeout;
        private Integer waitTimeSeconds;
        private String receiveRequestAttemptId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiveMessageRequest model) {
            this.setQueueUrl(model.queueUrl);
            this.setAttributeNames(model.attributeNames);
            this.setMessageAttributeNames(model.messageAttributeNames);
            this.setMaxNumberOfMessages(model.maxNumberOfMessages);
            this.setVisibilityTimeout(model.visibilityTimeout);
            this.setWaitTimeSeconds(model.waitTimeSeconds);
            this.setReceiveRequestAttemptId(model.receiveRequestAttemptId);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Collection<String> getAttributeNames() {
            return this.attributeNames;
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(QueueAttributeName ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames).stream().map(Object::toString).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
        }

        public final Collection<String> getMessageAttributeNames() {
            return this.messageAttributeNames;
        }

        @Override
        public final Builder messageAttributeNames(Collection<String> messageAttributeNames) {
            this.messageAttributeNames = MessageAttributeNameListCopier.copy(messageAttributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageAttributeNames(String ... messageAttributeNames) {
            this.messageAttributeNames(Arrays.asList(messageAttributeNames));
            return this;
        }

        public final void setMessageAttributeNames(Collection<String> messageAttributeNames) {
            this.messageAttributeNames = MessageAttributeNameListCopier.copy(messageAttributeNames);
        }

        public final Integer getMaxNumberOfMessages() {
            return this.maxNumberOfMessages;
        }

        @Override
        public final Builder maxNumberOfMessages(Integer maxNumberOfMessages) {
            this.maxNumberOfMessages = maxNumberOfMessages;
            return this;
        }

        public final void setMaxNumberOfMessages(Integer maxNumberOfMessages) {
            this.maxNumberOfMessages = maxNumberOfMessages;
        }

        public final Integer getVisibilityTimeout() {
            return this.visibilityTimeout;
        }

        @Override
        public final Builder visibilityTimeout(Integer visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        public final void setVisibilityTimeout(Integer visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
        }

        public final Integer getWaitTimeSeconds() {
            return this.waitTimeSeconds;
        }

        @Override
        public final Builder waitTimeSeconds(Integer waitTimeSeconds) {
            this.waitTimeSeconds = waitTimeSeconds;
            return this;
        }

        public final void setWaitTimeSeconds(Integer waitTimeSeconds) {
            this.waitTimeSeconds = waitTimeSeconds;
        }

        public final String getReceiveRequestAttemptId() {
            return this.receiveRequestAttemptId;
        }

        @Override
        public final Builder receiveRequestAttemptId(String receiveRequestAttemptId) {
            this.receiveRequestAttemptId = receiveRequestAttemptId;
            return this;
        }

        public final void setReceiveRequestAttemptId(String receiveRequestAttemptId) {
            this.receiveRequestAttemptId = receiveRequestAttemptId;
        }

        public ReceiveMessageRequest build() {
            return new ReceiveMessageRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReceiveMessageRequest> {
        public Builder queueUrl(String var1);

        public Builder attributeNames(Collection<String> var1);

        public Builder attributeNames(String ... var1);

        public Builder attributeNames(QueueAttributeName ... var1);

        public Builder messageAttributeNames(Collection<String> var1);

        public Builder messageAttributeNames(String ... var1);

        public Builder maxNumberOfMessages(Integer var1);

        public Builder visibilityTimeout(Integer var1);

        public Builder waitTimeSeconds(Integer var1);

        public Builder receiveRequestAttemptId(String var1);
    }
}

