/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.util.Map;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sqs.model.SetQueueAttributesRequest;

public class SetQueueAttributesRequestMarshaller
implements Marshaller<Request<SetQueueAttributesRequest>, SetQueueAttributesRequest> {
    public Request<SetQueueAttributesRequest> marshall(SetQueueAttributesRequest setQueueAttributesRequest) {
        Map<String, String> attributes;
        if (setQueueAttributesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)setQueueAttributesRequest, "SqsClient");
        request.addParameter("Action", "SetQueueAttributes");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (setQueueAttributesRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringConversion.fromString((String)setQueueAttributesRequest.queueUrl()));
        }
        if ((attributes = setQueueAttributesRequest.attributesAsStrings()) != null) {
            int attributesListIndex = 1;
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                if (entry.getKey() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".Name", StringConversion.fromString((String)entry.getKey()));
                }
                if (entry.getValue() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".Value", StringConversion.fromString((String)entry.getValue()));
                }
                ++attributesListIndex;
            }
        }
        return request;
    }
}

