/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.util.Map;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;

public class CreateQueueRequestMarshaller
implements Marshaller<Request<CreateQueueRequest>, CreateQueueRequest> {
    public Request<CreateQueueRequest> marshall(CreateQueueRequest createQueueRequest) {
        Map<String, String> attributes;
        if (createQueueRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createQueueRequest, "SqsClient");
        request.addParameter("Action", "CreateQueue");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (createQueueRequest.queueName() != null) {
            request.addParameter("QueueName", StringConversion.fromString((String)createQueueRequest.queueName()));
        }
        if ((attributes = createQueueRequest.attributesAsStrings()) != null) {
            int attributesListIndex = 1;
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                if (entry.getKey() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".Name", StringConversion.fromString((String)entry.getKey()));
                }
                if (entry.getValue() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".Value", StringConversion.fromString((String)entry.getValue()));
                }
                ++attributesListIndex;
            }
        }
        return request;
    }
}

