/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;

public class ChangeMessageVisibilityBatchRequestMarshaller
implements Marshaller<Request<ChangeMessageVisibilityBatchRequest>, ChangeMessageVisibilityBatchRequest> {
    public Request<ChangeMessageVisibilityBatchRequest> marshall(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) {
        if (changeMessageVisibilityBatchRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)changeMessageVisibilityBatchRequest, "SqsClient");
        request.addParameter("Action", "ChangeMessageVisibilityBatch");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (changeMessageVisibilityBatchRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringConversion.fromString((String)changeMessageVisibilityBatchRequest.queueUrl()));
        }
        if (changeMessageVisibilityBatchRequest.entries().isEmpty() && !(changeMessageVisibilityBatchRequest.entries() instanceof SdkAutoConstructList)) {
            request.addParameter("ChangeMessageVisibilityBatchRequestEntry", "");
        } else if (!changeMessageVisibilityBatchRequest.entries().isEmpty() && !(changeMessageVisibilityBatchRequest.entries() instanceof SdkAutoConstructList)) {
            List<ChangeMessageVisibilityBatchRequestEntry> entriesList = changeMessageVisibilityBatchRequest.entries();
            int entriesListIndex = 1;
            for (ChangeMessageVisibilityBatchRequestEntry entriesListValue : entriesList) {
                if (entriesListValue.id() != null) {
                    request.addParameter("ChangeMessageVisibilityBatchRequestEntry." + entriesListIndex + ".Id", StringConversion.fromString((String)entriesListValue.id()));
                }
                if (entriesListValue.receiptHandle() != null) {
                    request.addParameter("ChangeMessageVisibilityBatchRequestEntry." + entriesListIndex + ".ReceiptHandle", StringConversion.fromString((String)entriesListValue.receiptHandle()));
                }
                if (entriesListValue.visibilityTimeout() != null) {
                    request.addParameter("ChangeMessageVisibilityBatchRequestEntry." + entriesListIndex + ".VisibilityTimeout", StringConversion.fromInteger((Integer)entriesListValue.visibilityTimeout()));
                }
                ++entriesListIndex;
            }
        }
        return request;
    }
}

