/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.sqs.model.QueueAttributeMapCopier;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.services.sqs.model.SqsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetQueueAttributesRequest
extends SqsRequest
implements ToCopyableBuilder<Builder, SetQueueAttributesRequest> {
    private final String queueUrl;
    private final Map<String, String> attributes;

    private SetQueueAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.attributes = builder.attributes;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    public Map<QueueAttributeName, String> attributes() {
        return TypeConverter.convert(this.attributes, QueueAttributeName::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)QueueAttributeName.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, String> attributesAsStrings() {
        return this.attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetQueueAttributesRequest)) {
            return false;
        }
        SetQueueAttributesRequest other = (SetQueueAttributesRequest)((Object)obj);
        return Objects.equals(this.queueUrl(), other.queueUrl()) && Objects.equals(this.attributesAsStrings(), other.attributesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"SetQueueAttributesRequest").add("QueueUrl", (Object)this.queueUrl()).add("Attributes", this.attributesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueUrl": {
                return Optional.ofNullable(clazz.cast(this.queueUrl()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributesAsStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SqsRequest.BuilderImpl
    implements Builder {
        private String queueUrl;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SetQueueAttributesRequest model) {
            super(model);
            this.queueUrl(model.queueUrl);
            this.attributesWithStrings(model.attributes);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributesWithStrings(Map<String, String> attributes) {
            this.attributes = QueueAttributeMapCopier.copy(attributes);
            return this;
        }

        @Override
        public final Builder attributes(Map<QueueAttributeName, String> attributes) {
            this.attributes = QueueAttributeMapCopier.copyEnumToString(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = QueueAttributeMapCopier.copy(attributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetQueueAttributesRequest build() {
            return new SetQueueAttributesRequest(this);
        }
    }

    public static interface Builder
    extends SqsRequest.Builder,
    CopyableBuilder<Builder, SetQueueAttributesRequest> {
        public Builder queueUrl(String var1);

        public Builder attributesWithStrings(Map<String, String> var1);

        public Builder attributes(Map<QueueAttributeName, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

