/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.sqs.model.QueueAttributeMapCopier;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.services.sqs.model.SqsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQueueAttributesResponse
extends SqsResponse
implements ToCopyableBuilder<Builder, GetQueueAttributesResponse> {
    private final Map<String, String> attributes;

    private GetQueueAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
    }

    public Map<QueueAttributeName, String> attributes() {
        return TypeConverter.convert(this.attributes, QueueAttributeName::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)QueueAttributeName.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, String> attributesAsStrings() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueueAttributesResponse)) {
            return false;
        }
        GetQueueAttributesResponse other = (GetQueueAttributesResponse)((Object)obj);
        return Objects.equals(this.attributesAsStrings(), other.attributesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"GetQueueAttributesResponse").add("Attributes", this.attributesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributesAsStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SqsResponse.BuilderImpl
    implements Builder {
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueueAttributesResponse model) {
            super(model);
            this.attributesWithStrings(model.attributes);
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributesWithStrings(Map<String, String> attributes) {
            this.attributes = QueueAttributeMapCopier.copy(attributes);
            return this;
        }

        @Override
        public final Builder attributes(Map<QueueAttributeName, String> attributes) {
            this.attributes = QueueAttributeMapCopier.copyEnumToString(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = QueueAttributeMapCopier.copy(attributes);
        }

        @Override
        public GetQueueAttributesResponse build() {
            return new GetQueueAttributesResponse(this);
        }
    }

    public static interface Builder
    extends SqsResponse.Builder,
    CopyableBuilder<Builder, GetQueueAttributesResponse> {
        public Builder attributesWithStrings(Map<String, String> var1);

        public Builder attributes(Map<QueueAttributeName, String> var1);
    }
}

