/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;

public class DeleteMessageRequestMarshaller
implements Marshaller<Request<DeleteMessageRequest>, DeleteMessageRequest> {
    public Request<DeleteMessageRequest> marshall(DeleteMessageRequest deleteMessageRequest) {
        if (deleteMessageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)deleteMessageRequest, "SQSClient");
        request.addParameter("Action", "DeleteMessage");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteMessageRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)deleteMessageRequest.queueUrl()));
        }
        if (deleteMessageRequest.receiptHandle() != null) {
            request.addParameter("ReceiptHandle", StringUtils.fromString((String)deleteMessageRequest.receiptHandle()));
        }
        return request;
    }
}

