/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;

public class SendMessageResponseUnmarshaller
implements Unmarshaller<SendMessageResponse, StaxUnmarshallerContext> {
    private static SendMessageResponseUnmarshaller INSTANCE;

    public SendMessageResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        SendMessageResponse.Builder sendMessageResponse = SendMessageResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("MD5OfMessageBody", targetDepth)) {
                    sendMessageResponse.md5OfMessageBody(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MD5OfMessageAttributes", targetDepth)) {
                    sendMessageResponse.md5OfMessageAttributes(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MessageId", targetDepth)) {
                    sendMessageResponse.messageId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SequenceNumber", targetDepth)) continue;
                sendMessageResponse.sequenceNumber(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (SendMessageResponse)((Object)sendMessageResponse.build());
    }

    public static SendMessageResponseUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SendMessageResponseUnmarshaller();
        }
        return INSTANCE;
    }
}

