/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.nio.ByteBuffer;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.util.StringUtils;

public class SendMessageBatchRequestMarshaller
implements Marshaller<Request<SendMessageBatchRequest>, SendMessageBatchRequest> {
    public Request<SendMessageBatchRequest> marshall(SendMessageBatchRequest sendMessageBatchRequest) {
        SdkInternalList entriesList;
        if (sendMessageBatchRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)sendMessageBatchRequest, "SQSClient");
        request.addParameter("Action", "SendMessageBatch");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendMessageBatchRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)sendMessageBatchRequest.queueUrl()));
        }
        if (!(entriesList = (SdkInternalList)sendMessageBatchRequest.entries()).isEmpty() || !entriesList.isAutoConstruct()) {
            int entriesListIndex = 1;
            for (SendMessageBatchRequestEntry entriesListValue : entriesList) {
                if (entriesListValue.id() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".Id", StringUtils.fromString((String)entriesListValue.id()));
                }
                if (entriesListValue.messageBody() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageBody", StringUtils.fromString((String)entriesListValue.messageBody()));
                }
                if (entriesListValue.delaySeconds() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".DelaySeconds", StringUtils.fromInteger((Integer)entriesListValue.delaySeconds()));
                }
                Map<String, MessageAttributeValue> messageAttributes = entriesListValue.messageAttributes();
                int messageAttributesListIndex = 1;
                for (Map.Entry<String, MessageAttributeValue> entry : messageAttributes.entrySet()) {
                    if (entry.getKey() != null) {
                        request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Name", StringUtils.fromString((String)entry.getKey()));
                    }
                    if (entry.getValue() != null) {
                        SdkInternalList binaryListValuesList;
                        SdkInternalList stringListValuesList;
                        if (entry.getValue().stringValue() != null) {
                            request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Value.StringValue", StringUtils.fromString((String)entry.getValue().stringValue()));
                        }
                        if (entry.getValue().binaryValue() != null) {
                            request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Value.BinaryValue", StringUtils.fromByteBuffer((ByteBuffer)entry.getValue().binaryValue()));
                        }
                        if (!(stringListValuesList = (SdkInternalList)entry.getValue().stringListValues()).isEmpty() || !stringListValuesList.isAutoConstruct()) {
                            int stringListValuesListIndex = 1;
                            for (String stringListValuesListValue : stringListValuesList) {
                                if (stringListValuesListValue != null) {
                                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Value.StringListValue." + stringListValuesListIndex, StringUtils.fromString((String)stringListValuesListValue));
                                }
                                ++stringListValuesListIndex;
                            }
                        }
                        if (!(binaryListValuesList = (SdkInternalList)entry.getValue().binaryListValues()).isEmpty() || !binaryListValuesList.isAutoConstruct()) {
                            int binaryListValuesListIndex = 1;
                            for (ByteBuffer binaryListValuesListValue : binaryListValuesList) {
                                if (binaryListValuesListValue != null) {
                                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Value.BinaryListValue." + binaryListValuesListIndex, StringUtils.fromByteBuffer((ByteBuffer)binaryListValuesListValue));
                                }
                                ++binaryListValuesListIndex;
                            }
                        }
                        if (entry.getValue().dataType() != null) {
                            request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageAttribute." + messageAttributesListIndex + ".Value.DataType", StringUtils.fromString((String)entry.getValue().dataType()));
                        }
                    }
                    ++messageAttributesListIndex;
                }
                if (entriesListValue.messageDeduplicationId() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageDeduplicationId", StringUtils.fromString((String)entriesListValue.messageDeduplicationId()));
                }
                if (entriesListValue.messageGroupId() != null) {
                    request.addParameter("SendMessageBatchRequestEntry." + entriesListIndex + ".MessageGroupId", StringUtils.fromString((String)entriesListValue.messageGroupId()));
                }
                ++entriesListIndex;
            }
        }
        return request;
    }
}

