/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.MapEntry;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.transform.MessageAttributeValueUnmarshaller;

public class MessageUnmarshaller
implements Unmarshaller<Message, StaxUnmarshallerContext> {
    private static MessageUnmarshaller INSTANCE;

    public Message unmarshall(StaxUnmarshallerContext context) throws Exception {
        Message.Builder message;
        block12: {
            message = Message.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            HashMap<String, String> attributes = null;
            HashMap<String, Object> messageAttributes = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    message.attributes(attributes);
                    message.messageAttributes(messageAttributes);
                    break block12;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    Map.Entry<String, Object> entry;
                    if (context.testExpression("MessageId", targetDepth)) {
                        message.messageId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ReceiptHandle", targetDepth)) {
                        message.receiptHandle(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MD5OfBody", targetDepth)) {
                        message.md5OfBody(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Body", targetDepth)) {
                        message.body(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Attribute", targetDepth)) {
                        if (attributes == null) {
                            attributes = new HashMap<String, String>();
                        }
                        entry = AttributesMapEntryUnmarshaller.getInstance().unmarshall(context);
                        attributes.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    if (context.testExpression("MD5OfMessageAttributes", targetDepth)) {
                        message.md5OfMessageAttributes(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("MessageAttribute", targetDepth)) continue;
                    if (messageAttributes == null) {
                        messageAttributes = new HashMap<String, Object>();
                    }
                    entry = MessageAttributesMapEntryUnmarshaller.getInstance().unmarshall(context);
                    messageAttributes.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            message.attributes(attributes);
            message.messageAttributes(messageAttributes);
        }
        return (Message)message.build();
    }

    public static MessageUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MessageUnmarshaller();
        }
        return INSTANCE;
    }

    private static class MessageAttributesMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, MessageAttributeValue>, StaxUnmarshallerContext> {
        private static MessageAttributesMapEntryUnmarshaller INSTANCE;

        private MessageAttributesMapEntryUnmarshaller() {
        }

        public Map.Entry<String, MessageAttributeValue> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry entry = new MapEntry();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Name", targetDepth)) {
                        entry.setKey((Object)SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Value", targetDepth)) continue;
                    entry.setValue((Object)MessageAttributeValueUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static MessageAttributesMapEntryUnmarshaller getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new MessageAttributesMapEntryUnmarshaller();
            }
            return INSTANCE;
        }
    }

    private static class AttributesMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {
        private static AttributesMapEntryUnmarshaller INSTANCE;

        private AttributesMapEntryUnmarshaller() {
        }

        public Map.Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry entry = new MapEntry();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Name", targetDepth)) {
                        entry.setKey((Object)SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Value", targetDepth)) continue;
                    entry.setValue((Object)SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static AttributesMapEntryUnmarshaller getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new AttributesMapEntryUnmarshaller();
            }
            return INSTANCE;
        }
    }
}

