/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;

public class MessageAttributeValueUnmarshaller
implements Unmarshaller<MessageAttributeValue, StaxUnmarshallerContext> {
    private static MessageAttributeValueUnmarshaller INSTANCE;

    public MessageAttributeValue unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        MessageAttributeValue.Builder messageAttributeValue = MessageAttributeValue.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("StringValue", targetDepth)) {
                    messageAttributeValue.stringValue(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BinaryValue", targetDepth)) {
                    messageAttributeValue.binaryValue(SimpleTypeStaxUnmarshallers.ByteBufferUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StringListValue", targetDepth)) {
                    messageAttributeValue.stringListValues(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BinaryListValue", targetDepth)) {
                    messageAttributeValue.binaryListValues(SimpleTypeStaxUnmarshallers.ByteBufferUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DataType", targetDepth)) continue;
                messageAttributeValue.dataType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (MessageAttributeValue)messageAttributeValue.build();
    }

    public static MessageAttributeValueUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MessageAttributeValueUnmarshaller();
        }
        return INSTANCE;
    }
}

