/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.MessageListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReceiveMessageResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ReceiveMessageResponse> {
    private final List<Message> messages;

    private ReceiveMessageResponse(BuilderImpl builder) {
        this.messages = builder.messages;
    }

    public List<Message> messages() {
        return this.messages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.messages() == null ? 0 : this.messages().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiveMessageResponse)) {
            return false;
        }
        ReceiveMessageResponse other = (ReceiveMessageResponse)((Object)obj);
        if (other.messages() == null ^ this.messages() == null) {
            return false;
        }
        return other.messages() == null || other.messages().equals(this.messages());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.messages() != null) {
            sb.append("Messages: ").append(this.messages()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Message> messages = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiveMessageResponse model) {
            this.setMessages(model.messages);
        }

        public final Collection<Message> getMessages() {
            return this.messages;
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = MessageListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message ... messages) {
            if (this.messages == null) {
                this.messages = new SdkInternalList(messages.length);
            }
            for (Message e : messages) {
                this.messages.add(e);
            }
            return this;
        }

        public final void setMessages(Collection<Message> messages) {
            this.messages = MessageListCopier.copy(messages);
        }

        @SafeVarargs
        public final void setMessages(Message ... messages) {
            if (this.messages == null) {
                this.messages = new SdkInternalList(messages.length);
            }
            for (Message e : messages) {
                this.messages.add(e);
            }
        }

        public ReceiveMessageResponse build() {
            return new ReceiveMessageResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReceiveMessageResponse> {
        public Builder messages(Collection<Message> var1);

        public Builder messages(Message ... var1);
    }
}

