/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.services.sqs.model.QueueAttributeMapCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateQueueRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateQueueRequest> {
    private final String queueName;
    private final Map<String, String> attributes;

    private CreateQueueRequest(BuilderImpl builder) {
        this.queueName = builder.queueName;
        this.attributes = builder.attributes;
    }

    public String queueName() {
        return this.queueName;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.queueName() == null ? 0 : this.queueName().hashCode());
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQueueRequest)) {
            return false;
        }
        CreateQueueRequest other = (CreateQueueRequest)((Object)obj);
        if (other.queueName() == null ^ this.queueName() == null) {
            return false;
        }
        if (other.queueName() != null && !other.queueName().equals(this.queueName())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        return other.attributes() == null || other.attributes().equals(this.attributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.queueName() != null) {
            sb.append("QueueName: ").append(this.queueName()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String queueName;
        private Map<String, String> attributes = new SdkInternalMap();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQueueRequest model) {
            this.setQueueName(model.queueName);
            this.setAttributes(model.attributes);
        }

        public final String getQueueName() {
            return this.queueName;
        }

        @Override
        public final Builder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public final void setQueueName(String queueName) {
            this.queueName = queueName;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = QueueAttributeMapCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = QueueAttributeMapCopier.copy(attributes);
        }

        public CreateQueueRequest build() {
            return new CreateQueueRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateQueueRequest> {
        public Builder queueName(String var1);

        public Builder attributes(Map<String, String> var1);
    }
}

