/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.socialmessaging.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.socialmessaging.SocialMessagingAsyncClient;
import software.amazon.awssdk.services.socialmessaging.internal.UserAgentUtils;
import software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppTemplateLibraryRequest;
import software.amazon.awssdk.services.socialmessaging.model.ListWhatsAppTemplateLibraryResponse;
import software.amazon.awssdk.services.socialmessaging.model.MetaLibraryTemplateDefinition;

public class ListWhatsAppTemplateLibraryPublisher
implements SdkPublisher<ListWhatsAppTemplateLibraryResponse> {
    private final SocialMessagingAsyncClient client;
    private final ListWhatsAppTemplateLibraryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWhatsAppTemplateLibraryPublisher(SocialMessagingAsyncClient client, ListWhatsAppTemplateLibraryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWhatsAppTemplateLibraryPublisher(SocialMessagingAsyncClient client, ListWhatsAppTemplateLibraryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWhatsAppTemplateLibraryResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWhatsAppTemplateLibraryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MetaLibraryTemplateDefinition> metaLibraryTemplates() {
        Function<ListWhatsAppTemplateLibraryResponse, Iterator> getIterator = response -> {
            if (response != null && response.metaLibraryTemplates() != null) {
                return response.metaLibraryTemplates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWhatsAppTemplateLibraryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWhatsAppTemplateLibraryResponseFetcher
    implements AsyncPageFetcher<ListWhatsAppTemplateLibraryResponse> {
        private ListWhatsAppTemplateLibraryResponseFetcher() {
        }

        public boolean hasNextPage(ListWhatsAppTemplateLibraryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWhatsAppTemplateLibraryResponse> nextPage(ListWhatsAppTemplateLibraryResponse previousPage) {
            if (previousPage == null) {
                return ListWhatsAppTemplateLibraryPublisher.this.client.listWhatsAppTemplateLibrary(ListWhatsAppTemplateLibraryPublisher.this.firstRequest);
            }
            return ListWhatsAppTemplateLibraryPublisher.this.client.listWhatsAppTemplateLibrary((ListWhatsAppTemplateLibraryRequest)((Object)ListWhatsAppTemplateLibraryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

